/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.recipe.RecipeCondition;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class RecipeConditions {

    public static enum AmountCondition {
        EXCESSIVE,
        LACKING,
        ANY;


        public boolean matches(double value, double expected) {
            if (this == ANY) {
                return true;
            }
            if (expected == -1.0) {
                return false;
            }
            if (this == LACKING) {
                return value < expected;
            }
            return value > expected;
        }
    }

    public record IngredientsCondition(Map<Ingredient, AmountCondition> conditions) implements ScoreCondition
    {
        @Override
        public boolean matches(@Nullable BrewingStep expected, BrewingStep actual) {
            if (!(actual instanceof BrewingStep.IngredientsStep)) {
                return false;
            }
            BrewingStep.IngredientsStep actualIngredients = (BrewingStep.IngredientsStep)((Object)actual);
            for (Map.Entry<Ingredient, AmountCondition> condition : this.conditions.entrySet()) {
                int actualAmount = actualIngredients.ingredients().getOrDefault(condition.getKey(), -1);
                if (!(expected instanceof BrewingStep.IngredientsStep)) {
                    if (condition.getValue() == AmountCondition.ANY) continue;
                    return false;
                }
                BrewingStep.IngredientsStep expectedIngredients = (BrewingStep.IngredientsStep)((Object)expected);
                int expectedAmount = expectedIngredients.ingredients().getOrDefault(condition.getKey(), -1);
                if (actualAmount == -1) {
                    return false;
                }
                if (!(expectedAmount == -1 ? condition.getValue() != AmountCondition.ANY : !condition.getValue().matches(actualAmount, expectedAmount))) continue;
                return false;
            }
            return true;
        }
    }

    public record SingletonCondition(AmountCondition amountCondition, ScoreType type) implements ScoreCondition
    {
        @Override
        public boolean matches(@Nullable BrewingStep expected, BrewingStep actual) {
            if (expected != null && expected.getClass() != actual.getClass()) {
                return false;
            }
            return switch (this.type) {
                default -> throw new MatchException(null, null);
                case ScoreType.TIME -> {
                    BrewingStep.TimedStep actualTime;
                    if (actual instanceof BrewingStep.TimedStep && this.amountCondition.matches((actualTime = (BrewingStep.TimedStep)((Object)actual)).time().moment(), expected == null ? -1.0 : (double)((BrewingStep.TimedStep)((Object)expected)).time().moment())) {
                        yield true;
                    }
                    yield false;
                }
                case ScoreType.INGREDIENTS, ScoreType.BARREL_TYPE -> false;
                case ScoreType.DISTILL_AMOUNT -> {
                    if (expected instanceof BrewingStep.Distill) {
                        BrewingStep.Distill actualDistill;
                        BrewingStep.Distill expectedDistill = (BrewingStep.Distill)expected;
                        if (actual instanceof BrewingStep.Distill && this.amountCondition.matches((actualDistill = (BrewingStep.Distill)actual).runs(), expectedDistill.runs())) {
                            yield true;
                        }
                    }
                    yield false;
                }
            };
        }
    }

    public static interface ScoreCondition {
        public boolean matches(@Nullable BrewingStep var1, BrewingStep var2);
    }

    public record LastStep(BrewingStep.StepType stepType, List<ScoreCondition> conditions) implements RecipeCondition
    {
        @Override
        public boolean matches(@Nullable List<BrewingStep> expected, List<BrewingStep> actual) {
            if (actual.isEmpty()) {
                return false;
            }
            if (actual.getLast().stepType() != this.stepType) {
                return false;
            }
            return this.conditions().stream().allMatch(scoreCondition -> scoreCondition.matches(expected == null ? null : (BrewingStep)expected.get(Math.min(actual.size(), expected.size()) - 1), (BrewingStep)actual.getLast()));
        }

        @Override
        public int complexity() {
            return 1 + this.conditions.size();
        }
    }

    public static class NoCondition
    implements RecipeCondition {
        @Override
        public boolean matches(@Nullable List<BrewingStep> expected, List<BrewingStep> actual) {
            return true;
        }

        @Override
        public int complexity() {
            return 0;
        }
    }
}

