/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.database.sql;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public enum DatabaseDriver {
    SQLITE,
    MYSQL("mariadb"),
    POSTGRESQL("postgre");

    private List<String> alias;

    private DatabaseDriver() {
        this.alias = List.of(this.name().toLowerCase(Locale.ROOT));
    }

    private DatabaseDriver(String ... alias) {
        this.alias = Streams.concat((Stream[])new Stream[]{Arrays.stream(alias), Stream.of(this.name().toLowerCase(Locale.ROOT))}).toList();
    }

    @Nullable
    public static DatabaseDriver fromString(String databaseDriverString) {
        for (DatabaseDriver databaseDriver : DatabaseDriver.values()) {
            if (!databaseDriver.alias.contains(databaseDriverString.toLowerCase(Locale.ROOT))) continue;
            return databaseDriver;
        }
        return null;
    }
}

