/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.ingredient;

import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.ScoredIngredient;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.configuration.IngredientsSection;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.persistence.PersistentDataContainerView;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BreweryIngredient
implements Ingredient {
    protected final BreweryKey ingredientKey;
    private final String displayName;

    public BreweryIngredient(BreweryKey ingredientKey, String displayName) {
        this.ingredientKey = ingredientKey;
        this.displayName = displayName;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.ingredientKey.toString();
    }

    @Override
    @NotNull
    public Component displayName() {
        return MessageUtil.miniMessage(this.displayName, new TagResolver[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BreweryIngredient that = (BreweryIngredient)o;
        return Objects.equals(this.ingredientKey, that.ingredientKey);
    }

    public int hashCode() {
        return Objects.hashCode(this.ingredientKey);
    }

    public static Optional<Ingredient> from(ItemStack itemStack) {
        PersistentDataContainerView dataContainer = itemStack.getPersistentDataContainer();
        String key = (String)dataContainer.get(BrewAdapter.BREWERY_TAG, PersistentDataType.STRING);
        if (key == null) {
            return Optional.empty();
        }
        Double score = (Double)dataContainer.get(BrewAdapter.BREWERY_SCORE, PersistentDataType.DOUBLE);
        String displayName = (String)dataContainer.get(BrewAdapter.BREWERY_DISPLAY_NAME, PersistentDataType.STRING);
        BreweryKey breweryKey = BreweryKey.parse(key);
        String string = displayName = displayName == null ? breweryKey.key() : displayName;
        if (score != null) {
            return Optional.of(new ScoredIngredient(new BreweryIngredient(breweryKey, displayName), score));
        }
        return Optional.of(new BreweryIngredient(breweryKey, displayName));
    }

    public static Optional<CompletableFuture<Optional<Ingredient>>> from(String id) {
        if (!id.startsWith("brewery:") && !id.startsWith("#brewery:")) {
            return Optional.empty();
        }
        BreweryKey breweryKey = BreweryKey.parse(id);
        if (breweryKey.namespace().startsWith("#")) {
            return Optional.of(IngredientsSection.ingredients().getIngredient(id));
        }
        return Optional.of(new BreweryIngredient(breweryKey, breweryKey.key())).map(Optional::of).map(CompletableFuture::completedFuture);
    }
}

