/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.effect;

import dev.jsinco.brewery.api.effect.DrunkState;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.bukkit.effect.SqlDrunkenModifierDataType;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.SqlStatements;
import dev.jsinco.brewery.effect.DrunkStateDataType;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.util.DecoderEncoder;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public class SqlDrunkStateDataType
implements DrunkStateDataType<Connection> {
    public static final SqlDrunkStateDataType INSTANCE = new SqlDrunkStateDataType();
    private final SqlStatements statements = new SqlStatements("/database/generic/drunk_states");

    @Override
    public void update(Pair<DrunkState, UUID> newValue, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.UPDATE));){
            DrunkState drunkState = newValue.first();
            preparedStatement.setLong(1, drunkState.kickedTimestamp());
            preparedStatement.setLong(2, drunkState.timestamp());
            preparedStatement.setBytes(3, DecoderEncoder.asBytes(newValue.second()));
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void insert(Pair<DrunkState, UUID> value, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.INSERT));){
            DrunkState drunkState = value.first();
            preparedStatement.setBytes(1, DecoderEncoder.asBytes(value.second()));
            preparedStatement.setLong(2, drunkState.kickedTimestamp());
            preparedStatement.setLong(3, drunkState.timestamp());
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public void remove(UUID toRemove, Connection connection) throws PersistenceException {
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.DELETE));){
            preparedStatement.setBytes(1, DecoderEncoder.asBytes(toRemove));
            preparedStatement.execute();
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
    }

    @Override
    public List<Pair<DrunkState, UUID>> retrieveAll(Connection connection) throws PersistenceException {
        ArrayList<Pair<DrunkStateImpl, UUID>> drunks = new ArrayList<Pair<DrunkStateImpl, UUID>>();
        try (PreparedStatement preparedStatement = connection.prepareStatement(this.statements.get(SqlStatements.Type.SELECT_ALL));){
            ResultSet resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                drunks.add(new Pair<DrunkStateImpl, UUID>(new DrunkStateImpl(resultSet.getLong("time_stamp"), resultSet.getLong("kicked_timestamp"), Map.of()), DecoderEncoder.asUuid(resultSet.getBytes("player_uuid"))));
            }
        }
        catch (SQLException e) {
            throw new PersistenceException(e);
        }
        ArrayList<Pair<DrunkState, UUID>> output = new ArrayList<Pair<DrunkState, UUID>>();
        for (Pair pair : drunks) {
            Map<DrunkenModifier, Double> modifiers = SqlDrunkenModifierDataType.INSTANCE.find((UUID)pair.second(), connection).stream().collect(Collectors.toUnmodifiableMap(Pair::first, Pair::second));
            output.add(new Pair<DrunkState, UUID>(((DrunkState)pair.first()).withModifiers(modifiers), (UUID)pair.second()));
        }
        return output;
    }
}

