/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command.argument;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;

public class EnumArgument<E extends Enum<E>>
implements CustomArgumentType.Converted<E, String> {
    private static final DynamicCommandExceptionType ERROR_INVALID_ENUM = new DynamicCommandExceptionType(event -> BukkitMessageUtil.toBrigadier("tbp.command.illegal-argument-detailed", new TagResolver[]{Placeholder.unparsed((String)"arguments", (String)event.toString())}));
    private final Class<E> eClass;

    public EnumArgument(Class<E> eClass) {
        this.eClass = eClass;
    }

    public E convert(String nativeType) throws CommandSyntaxException {
        try {
            return Enum.valueOf(this.eClass, nativeType.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            throw ERROR_INVALID_ENUM.create((Object)nativeType);
        }
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, SuggestionsBuilder builder) {
        Arrays.stream((Enum[])this.eClass.getEnumConstants()).map(Enum::name).map(name -> name.toLowerCase(Locale.ROOT)).filter(enumConstant -> enumConstant.startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.word();
    }
}

