/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.ingredient.IngredientUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class BrewingStepSerializer {
    public static final BrewingStepSerializer INSTANCE = new BrewingStepSerializer();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JsonObject serialize(BrewingStep step) {
        JsonObject object = new JsonObject();
        object.addProperty("type", step.stepType().name().toLowerCase(Locale.ROOT));
        BrewingStep brewingStep = step;
        Objects.requireNonNull(brewingStep);
        BrewingStep brewingStep2 = brewingStep;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AgeStepImpl.class, CookStepImpl.class, DistillStepImpl.class, MixStepImpl.class}, (Object)brewingStep2, n)) {
            case 0: {
                Object type;
                Moment age;
                AgeStepImpl ageStepImpl = (AgeStepImpl)brewingStep2;
                try {
                    Object object2 = ageStepImpl.time();
                    age = object2;
                    type = object2 = ageStepImpl.barrelType();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                object.add("age", Moment.SERIALIZER.serialize(age));
                object.addProperty("barrel_type", ((BarrelType)type).key().toString());
                return object;
            }
            case 1: {
                Object cauldronType;
                Object ingredients;
                Moment brewTime;
                CookStepImpl cookStepImpl = (CookStepImpl)brewingStep2;
                {
                    Object object3 = cookStepImpl.time();
                    brewTime = object3;
                    ingredients = object3 = cookStepImpl.ingredients();
                    cauldronType = object3 = cookStepImpl.cauldronType();
                }
                object.add("brew_time", Moment.SERIALIZER.serialize(brewTime));
                object.addProperty("cauldron_type", ((CauldronType)cauldronType).key().toString());
                object.add("ingredients", (JsonElement)IngredientUtil.ingredientsToJson((Map<Ingredient, Integer>)ingredients));
                return object;
            }
            case 2: {
                int runs;
                DistillStepImpl distillStepImpl = (DistillStepImpl)brewingStep2;
                {
                    int n2;
                    runs = n2 = distillStepImpl.runs();
                }
                object.addProperty("runs", (Number)runs);
                return object;
            }
            case 3: {
                Object ingredients;
                Moment time;
                MixStepImpl mixStepImpl = (MixStepImpl)brewingStep2;
                {
                    Object object4 = mixStepImpl.time();
                    time = object4;
                    ingredients = object4 = mixStepImpl.ingredients();
                }
                object.add("ingredients", (JsonElement)IngredientUtil.ingredientsToJson((Map<Ingredient, Integer>)ingredients));
                object.add("mix_time", Moment.SERIALIZER.serialize(time));
                return object;
            }
        }
        throw new IllegalStateException("Unexpected value: " + String.valueOf(step));
    }

    public CompletableFuture<BrewingStep> deserialize(JsonElement jsonElement, IngredientManager<?> ingredientManager) {
        JsonObject object = jsonElement.getAsJsonObject();
        BrewingStep.StepType stepType = BrewingStep.StepType.valueOf(object.get("type").getAsString().toUpperCase(Locale.ROOT));
        return switch (stepType) {
            default -> throw new MatchException(null, null);
            case BrewingStep.StepType.COOK -> IngredientUtil.ingredientsFromJson(object.get("ingredients").getAsJsonObject(), ingredientManager).thenApplyAsync(ingredients -> new CookStepImpl(Moment.SERIALIZER.deserialize(object.get("brew_time")), (Map<? extends Ingredient, Integer>)ingredients, BreweryRegistry.CAULDRON_TYPE.get(BreweryKey.parse(object.get("cauldron_type").getAsString()))));
            case BrewingStep.StepType.DISTILL -> CompletableFuture.completedFuture(new DistillStepImpl(object.get("runs").getAsInt()));
            case BrewingStep.StepType.AGE -> CompletableFuture.completedFuture(new AgeStepImpl(Moment.SERIALIZER.deserialize(object.get("age")), BreweryRegistry.BARREL_TYPE.get(BreweryKey.parse(object.get("barrel_type").getAsString()))));
            case BrewingStep.StepType.MIX -> IngredientUtil.ingredientsFromJson(object.get("ingredients").getAsJsonObject(), ingredientManager).thenApplyAsync(ingredients -> new MixStepImpl(Moment.SERIALIZER.deserialize(object.get("mix_time")), (Map<? extends Ingredient, Integer>)ingredients));
        };
    }
}

