/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.brew;

import com.google.errorprone.annotations.Immutable;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.recipe.RecipeRegistry;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Immutable
public interface Brew {
    public <I> Optional<Recipe<I>> closestRecipe(RecipeRegistry<I> var1);

    @NotNull
    public BrewScore score(Recipe<?> var1);

    public Optional<BrewQuality> quality(Recipe<?> var1);

    public BrewingStep lastCompletedStep();

    public BrewingStep lastStep();

    public Brew withStep(BrewingStep var1);

    public Brew witModifiedLastStep(Function<BrewingStep, BrewingStep> var1);

    public <B extends BrewingStep> Brew withLastStep(Class<B> var1, Function<B, B> var2, Supplier<B> var3);

    public List<BrewingStep> getCompletedSteps();

    public List<BrewingStep> getSteps();

    public static sealed interface State {

        public record Seal(@Nullable String message) implements State
        {
        }

        public record Other() implements State
        {
        }

        public record Brewing() implements State
        {
        }
    }
}

