/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.jetbrains.annotations.NotNull;

public final class FileUtil {
    public static void extractFile(@NotNull Class<?> clazz, @NotNull String filename, @NotNull Path outDir, boolean replace) {
        try (InputStream in = clazz.getResourceAsStream("/" + filename);){
            if (in == null) {
                throw new RuntimeException("Could not read file from jar! (" + filename + ")");
            }
            Path path = outDir.resolve(filename);
            if (!Files.exists(path, new LinkOption[0]) || replace) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(in, path, StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readInternalResource(String path) {
        try (InputStream inputStream = FileUtil.class.getResourceAsStream(path);){
            if (inputStream == null) {
                String string2 = "";
                return string2;
            }
            String string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonElement readJsonResource(String path) {
        JsonElement jsonElement;
        block9: {
            InputStream inputStream = FileUtil.class.getResourceAsStream(path);
            try {
                if (inputStream == null) {
                    throw new FileNotFoundException(path);
                }
                jsonElement = JsonParser.parseReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            inputStream.close();
        }
        return jsonElement;
    }
}

