/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import com.mojang.brigadier.Message;
import dev.jsinco.brewery.api.effect.modifier.DrunkenModifier;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffect;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffects;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class BukkitMessageUtil {
    private BukkitMessageUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Message toBrigadier(String translation, TagResolver ... resolvers) {
        return (Message)MessageComponentSerializer.message().serialize((Component)Component.translatable((String)translation, (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver[])resolvers)}));
    }

    public static TagResolver recipeEffectResolver(RecipeEffects effects) {
        List<DrunkenModifier> modifiers = effects.getModifiers().keySet().stream().sorted(Comparator.comparing(DrunkenModifier::name, String::compareTo)).toList();
        TagResolver.Builder builder = TagResolver.builder().resolver((TagResolver)Placeholder.component((String)"potion_effects", (ComponentLike)((ComponentLike)effects.getEffects().stream().map(RecipeEffect::displayName).collect(Component.toComponent((Component)Component.text((String)", ")))))).resolver((TagResolver)Placeholder.parsed((String)"effect_title_message", (String)(effects.getTitle() == null ? "" : effects.getTitle()))).resolver((TagResolver)Placeholder.parsed((String)"effect_message", (String)(effects.getMessage() == null ? "" : effects.getMessage()))).resolver((TagResolver)Placeholder.parsed((String)"effect_action_bar", (String)(effects.getActionBar() == null ? "" : effects.getActionBar()))).resolver((TagResolver)Placeholder.component((String)"effect_events", (ComponentLike)((ComponentLike)effects.getEvents().stream().map(DrunkEvent::displayName).collect(Component.toComponent((Component)Component.text((String)", ")))))).resolver((TagResolver)Placeholder.component((String)"modifier_name_definition", (ComponentLike)((ComponentLike)modifiers.stream().map(DrunkenModifier::displayName).collect(Component.toComponent((Component)Component.text((String)"/").color((TextColor)NamedTextColor.GOLD)))))).resolver((TagResolver)Placeholder.component((String)"modifier_value_definition", (ComponentLike)((ComponentLike)modifiers.stream().map(effects.getModifiers()::get).map(Component::text).collect(Component.toComponent((Component)Component.text((String)"/").color((TextColor)NamedTextColor.GOLD))))));
        return builder.build();
    }

    public static TagResolver getPlayerTagResolver(@Nullable OfflinePlayer offlinePlayer) {
        TagResolver.Builder output = TagResolver.builder();
        if (offlinePlayer instanceof Player) {
            Player player = (Player)offlinePlayer;
            output.resolver((TagResolver)Placeholder.component((String)"player_name", (ComponentLike)player.name()));
        } else {
            String offlineName = offlinePlayer == null ? null : offlinePlayer.getName();
            output.resolver((TagResolver)Placeholder.unparsed((String)"player_name", (String)(offlineName != null ? offlineName : "unknown_player")));
        }
        if (offlinePlayer == null) {
            return output.build();
        }
        output.resolver(TagResolver.resolver((TagResolver[])((TagResolver[])TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationTypes.PLACEHOLDER).stream().map(placeholderIntegration -> placeholderIntegration.resolve(offlinePlayer)).toArray(TagResolver[]::new))));
        return output.build();
    }
}

