/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure;

import dev.jsinco.brewery.api.structure.BlockMatcherReplacement;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.structure.BlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.Material;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;

public class GenericBlockDataMatcher
implements BlockDataMatcher<Void> {
    private final List<BlockMatcherReplacement> ambiguities;

    public GenericBlockDataMatcher(List<BlockMatcherReplacement> ambiguities) {
        this.ambiguities = ambiguities;
    }

    @Override
    public boolean matches(BlockData actual, BlockData expected, Void ignored) {
        if (expected instanceof MultipleFacing) {
            return this.materialMatches(expected.getMaterial(), actual.getMaterial());
        }
        if (expected.getMaterial() == Material.DECORATED_POT) {
            return actual.getMaterial() == Material.DECORATED_POT;
        }
        return this.materials(expected.getMaterial()).map(material -> {
            BlockData revised = material.createBlockData();
            expected.copyTo(revised);
            return revised;
        }).anyMatch(arg_0 -> ((BlockData)actual).matches(arg_0));
    }

    @Override
    public Set<Material> findStructureMaterials(Void matcherType, BreweryStructure structure) {
        return structure.getPalette().stream().map(BlockData::getMaterial).flatMap(this::materials).collect(Collectors.toSet());
    }

    private Stream<Material> materials(Material expected) {
        return Stream.concat(this.ambiguities.stream().filter(ambiguity -> expected.equals((Object)BukkitAdapter.toMaterial(ambiguity.original()))).flatMap(ambiguity -> ambiguity.alternatives().stream()).map(BukkitAdapter::toMaterial), Stream.of(expected));
    }

    public boolean materialMatches(Material expected, Material actual) {
        if (this.ambiguities.stream().filter(ambiguities -> expected.equals((Object)BukkitAdapter.toMaterial(ambiguities.original()))).anyMatch(ambiguities -> ambiguities.alternatives().contains(BukkitAdapter.toMaterialHolder(actual)) || ambiguities.original().equals(BukkitAdapter.toMaterialHolder(actual)))) {
            return true;
        }
        return expected == actual;
    }
}

