/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.structure;

import com.google.gson.JsonElement;
import dev.jsinco.brewery.api.structure.BlockMatcherReplacement;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryKeyed;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.api.util.HolderProviderHolder;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public record StructureMeta<V>(BreweryKey key, Predicate<Object> validator, Function<JsonElement, V> deserializer, V defaultValue) implements BreweryKeyed
{
    public static final StructureMeta<Boolean> USE_BARREL_SUBSTITUTION = new StructureMeta<Boolean>(BreweryKey.parse("use_barrel_substitution"), Boolean.class::isInstance, JsonElement::getAsBoolean, false);
    public static final StructureMeta<Integer> INVENTORY_SIZE = new StructureMeta<Integer>(BreweryKey.parse("inventory_size"), value -> {
        Integer integer;
        return value instanceof Integer && (integer = (Integer)value) % 9 == 0 && integer > 0;
    }, JsonElement::getAsInt, 9);
    public static final StructureMeta<String> TAGGED_MATERIAL = new StructureMeta<String>(BreweryKey.parse("tagged_material"), String.class::isInstance, JsonElement::getAsString, "decorated_pot");
    public static final StructureMeta<Long> PROCESS_TIME = new StructureMeta<Long>(BreweryKey.parse("process_time"), Long.class::isInstance, JsonElement::getAsLong, 80L);
    public static final StructureMeta<Integer> PROCESS_AMOUNT = new StructureMeta<Integer>(BreweryKey.parse("process_amount"), Integer.class::isInstance, JsonElement::getAsInt, 1);
    public static final StructureMeta<List<BlockMatcherReplacement>> BLOCK_REPLACEMENTS = new StructureMeta(BreweryKey.parse("replacements"), List.class::isInstance, jsonElement -> jsonElement.getAsJsonArray().asList().stream().map(StructureMeta::deserializeReplacement).toList(), List.of());
    public static final StructureMeta<StructureType> TYPE = new StructureMeta<StructureType>(BreweryKey.parse("type"), StructureType.class::isInstance, jsonElement -> BreweryRegistry.STRUCTURE_TYPE.get(BreweryKey.parse(jsonElement.getAsString().toLowerCase(Locale.ROOT))), StructureType.BARREL);

    @Override
    @NotNull
    public String toString() {
        return "StructureMeta(" + String.valueOf(this.key) + ")";
    }

    private static BlockMatcherReplacement deserializeReplacement(JsonElement element) {
        JsonElement original = element.getAsJsonObject().get("original");
        Holder.Material originalHolder = HolderProviderHolder.instance().material(original.getAsString()).orElseThrow(() -> new IllegalArgumentException("Expected a valid material, got: " + original.getAsString()));
        JsonElement replacement = element.getAsJsonObject().get("replacement");
        if (replacement.isJsonArray()) {
            return new BlockMatcherReplacement(replacement.getAsJsonArray().asList().stream().map(JsonElement::getAsString).flatMap(StructureMeta::parseMaterials).collect(Collectors.toUnmodifiableSet()), originalHolder);
        }
        return new BlockMatcherReplacement(StructureMeta.parseMaterials(replacement.getAsString()).collect(Collectors.toUnmodifiableSet()), originalHolder);
    }

    private static Stream<Holder.Material> parseMaterials(String string) {
        if (string.startsWith("#")) {
            return HolderProviderHolder.instance().parseTag(string.replaceFirst("#", "")).stream();
        }
        return HolderProviderHolder.instance().material(string).stream();
    }
}

