/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.util;

import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.util.ItemColorUtil;
import java.awt.Color;
import java.util.Map;
import org.jspecify.annotations.Nullable;

public class IngredientUtil {
    public static Pair<org.bukkit.Color, @Nullable Ingredient> ingredientData(Map<? extends Ingredient, Integer> ingredients) {
        int r = 0;
        int g = 0;
        int b = 0;
        int amount = 0;
        Ingredient topIngredient = null;
        int topIngredientAmount = 0;
        for (Map.Entry<? extends Ingredient, Integer> ingredient : ingredients.entrySet()) {
            String key;
            Color color;
            if (topIngredientAmount < ingredient.getValue()) {
                topIngredient = ingredient.getKey();
                topIngredientAmount = ingredient.getValue();
            }
            if ((color = ItemColorUtil.getItemColor(key = ingredient.getKey().getKey())) == null) continue;
            r += color.getRed() * ingredient.getValue();
            g += color.getGreen() * ingredient.getValue();
            b += color.getBlue() * ingredient.getValue();
            amount += ingredient.getValue().intValue();
        }
        if (amount != 0) {
            return new Pair<org.bukkit.Color, Ingredient>(org.bukkit.Color.fromRGB((int)(r / amount), (int)(g / amount), (int)(b / amount)), topIngredient);
        }
        return new Pair<org.bukkit.Color, Object>(org.bukkit.Color.YELLOW, topIngredient);
    }
}

