/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientManager;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.api.moment.PassedMoment;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.DistillStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.DecoderEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.NullCipher;
import org.bukkit.persistence.PersistentDataAdapterContext;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.NotNull;

public class BrewingStepPdcType
implements PersistentDataType<byte[], BrewingStep> {
    private final boolean useCipher;

    public BrewingStepPdcType(boolean useCipher) {
        this.useCipher = useCipher;
    }

    @NotNull
    public Class<byte[]> getPrimitiveType() {
        return byte[].class;
    }

    @NotNull
    public Class<BrewingStep> getComplexType() {
        return BrewingStep.class;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public byte @NotNull [] toPrimitive(@NotNull BrewingStep complex, @NotNull PersistentDataAdapterContext context) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (CipherOutputStream cipherOutputStream = new CipherOutputStream(output, this.getCipher(1));
             DataOutputStream dataOutputStream = new DataOutputStream(cipherOutputStream);){
            dataOutputStream.writeUTF(complex.stepType().name());
            BrewingStep brewingStep = complex;
            Objects.requireNonNull(brewingStep);
            BrewingStep brewingStep2 = brewingStep;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BrewingStep.Age.class, BrewingStep.Cook.class, BrewingStep.Distill.class, BrewingStep.Mix.class}, (Object)brewingStep2, n)) {
                case 0: {
                    BrewingStep.Age age = (BrewingStep.Age)brewingStep2;
                    this.encodeMoment(age.time(), dataOutputStream);
                    dataOutputStream.writeUTF(age.barrelType().key().toString());
                    return output.toByteArray();
                }
                case 1: {
                    BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep2;
                    this.encodeMoment(cook.time(), dataOutputStream);
                    this.encodeIngredients(cook.ingredients(), dataOutputStream);
                    dataOutputStream.writeUTF(cook.cauldronType().key().toString());
                    return output.toByteArray();
                }
                case 2: {
                    BrewingStep.Distill distill = (BrewingStep.Distill)brewingStep2;
                    dataOutputStream.writeInt(distill.runs());
                    return output.toByteArray();
                }
                case 3: {
                    BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep2;
                    this.encodeMoment(mix.time(), dataOutputStream);
                    this.encodeIngredients(mix.ingredients(), dataOutputStream);
                    return output.toByteArray();
                }
                default: {
                    throw new IllegalStateException("Unexpected value: " + String.valueOf(complex));
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public BrewingStep fromPrimitive(byte @NotNull [] primitive, @NotNull PersistentDataAdapterContext context) {
        ByteArrayInputStream input = new ByteArrayInputStream(primitive);
        try (CipherInputStream cipherInputStream = new CipherInputStream(input, this.getCipher(2));){
            Record record;
            try (DataInputStream dataInputStream = new DataInputStream(cipherInputStream);){
                BrewingStep.StepType stepType = BrewingStep.StepType.valueOf(dataInputStream.readUTF());
                record = switch (stepType) {
                    default -> throw new MatchException(null, null);
                    case BrewingStep.StepType.COOK -> new CookStepImpl(this.decodeMoment(dataInputStream), this.decodeIngredients(dataInputStream), BreweryRegistry.CAULDRON_TYPE.get(BreweryKey.parse(dataInputStream.readUTF())));
                    case BrewingStep.StepType.DISTILL -> new DistillStepImpl(dataInputStream.readInt());
                    case BrewingStep.StepType.AGE -> new AgeStepImpl(this.decodeMoment(dataInputStream), BreweryRegistry.BARREL_TYPE.get(BreweryKey.parse(dataInputStream.readUTF())));
                    case BrewingStep.StepType.MIX -> new MixStepImpl(this.decodeMoment(dataInputStream), this.decodeIngredients(dataInputStream));
                };
            }
            return record;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void encodeMoment(Moment moment, DataOutputStream dataOutputStream) throws IOException {
        long stop;
        long start;
        if (!(moment instanceof Interval)) {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeLong(moment.moment());
            return;
        }
        Interval interval = (Interval)moment;
        try {
            long l;
            start = l = interval.start();
            stop = l = interval.stop();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        dataOutputStream.writeBoolean(false);
        dataOutputStream.writeLong(start);
        dataOutputStream.writeLong(stop);
    }

    private Moment decodeMoment(DataInputStream dataInputStream) throws IOException {
        if (dataInputStream.readBoolean()) {
            return new PassedMoment(dataInputStream.readLong());
        }
        return new Interval(dataInputStream.readLong(), dataInputStream.readLong());
    }

    public void encodeIngredients(@NotNull Map<? extends Ingredient, Integer> ingredients, OutputStream outputStream) {
        byte[][] bytesArray = (byte[][])ingredients.entrySet().stream().map(entry -> ((Ingredient)entry.getKey()).getKey() + "/" + String.valueOf(entry.getValue())).map(string -> string.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
        try {
            DecoderEncoder.encode(bytesArray, outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public Map<? extends Ingredient, Integer> decodeIngredients(InputStream inputStream) {
        byte[][] bytesArray;
        HashMap ingredients = new HashMap();
        try {
            bytesArray = DecoderEncoder.decode(inputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Arrays.stream(bytesArray).map(bytes -> new String((byte[])bytes, StandardCharsets.UTF_8)).map(BukkitIngredientManager.INSTANCE::getIngredientWithAmount).forEach(ingredientAmountPair -> IngredientManager.insertIngredientIntoMap(ingredients, (Pair)ingredientAmountPair.join()));
        return ingredients;
    }

    private Cipher getCipher(int operationMode) {
        try {
            NullCipher cipher = Config.config().encryptSensitiveData() && this.useCipher ? Cipher.getInstance("des") : new NullCipher();
            cipher.init(operationMode, Config.config().encryptionKey());
            return cipher;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
    }
}

