/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.obj;

import com.google.common.base.Preconditions;
import dev.jsinco.malts.api.events.interfaces.EventAction;
import dev.jsinco.malts.api.events.warehouse.WarehouseCompartmentEvent;
import dev.jsinco.malts.api.events.warehouse.WarehouseDestockEvent;
import dev.jsinco.malts.api.events.warehouse.WarehouseStockEvent;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.enums.TriState;
import dev.jsinco.malts.gui.item.GuiItem;
import dev.jsinco.malts.obj.CachedObject;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Stock;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Warehouse
implements CachedObject {
    private static final GuiConfig guiCfg = ConfigManager.get(GuiConfig.class);
    private static final Config cfg = ConfigManager.get(Config.class);
    private static final Lang lng = ConfigManager.get(Lang.class);
    private Long expire;
    private final UUID owner;
    private final EnumMap<Material, Stock> warehouseMap;

    public Warehouse(UUID owner, EnumMap<Material, Stock> warehouseMap) {
        this.owner = owner;
        this.warehouseMap = warehouseMap;
    }

    public Warehouse(UUID owner) {
        this.owner = owner;
        this.warehouseMap = new EnumMap(Material.class);
    }

    public int stockItem(Material material, int amt) {
        WarehouseStockEvent stockEvent;
        boolean async;
        MaltsPlayer maltsPlayer = DataSource.getInstance().cachedObject(this.owner, MaltsPlayer.class);
        Preconditions.checkNotNull((Object)maltsPlayer, (Object)("MaltsPlayer is null for owner: " + String.valueOf(this.owner)));
        int currentStockQuantity = this.currentStockQuantity();
        int maxWarehouseStock = maltsPlayer.getCalculatedMaxWarehouseStock();
        boolean bl = async = !Bukkit.isPrimaryThread();
        if (!material.isItem()) {
            throw new IllegalArgumentException("Material must be an item");
        }
        if (currentStockQuantity + amt > maxWarehouseStock) {
            amt = maxWarehouseStock - currentStockQuantity;
        }
        if (!(stockEvent = new WarehouseStockEvent(this, material, amt, async)).callEvent()) {
            return 0;
        }
        material = stockEvent.getMaterial();
        amt = stockEvent.getAmount();
        Stock stock = this.warehouseMap.get(material);
        if (stock != null) {
            stock.increase(amt);
        } else {
            WarehouseCompartmentEvent compartmentEvent = new WarehouseCompartmentEvent(this, EventAction.ADD, material, async);
            if (!compartmentEvent.callEvent()) {
                return 0;
            }
            material = compartmentEvent.getMaterial();
            this.warehouseMap.put(material, new Stock(material, amt));
        }
        return amt;
    }

    @Nullable
    public ItemStack destockItem(Material material, int amt) {
        Stock stock = this.warehouseMap.get(material);
        if (stock == null) {
            return null;
        }
        WarehouseDestockEvent event = new WarehouseDestockEvent(this, material, stock.getAmount(), !Bukkit.isPrimaryThread());
        event.setCancelled(stock.getAmount() < 1);
        if (!event.callEvent()) {
            return null;
        }
        if (event.getAmount() < amt) {
            amt = event.getAmount();
        }
        if (amt < 1) {
            return null;
        }
        stock.decrease(amt);
        return ItemStack.of((Material)material, (int)amt);
    }

    public boolean canStock(Material material) {
        return (!cfg.warehouse().blacklistSingleStackMaterials() || material.getMaxStackSize() != 1) && !cfg.warehouse().blacklistedMaterials().contains(material);
    }

    public boolean hasItem(Material material) {
        return this.warehouseMap.containsKey(material);
    }

    public int getQuantity(Material material) {
        Stock stock = this.warehouseMap.get(material);
        return stock != null ? stock.getAmount() : 0;
    }

    public Map<Material, Integer> stockCopy() {
        HashMap newMap = new HashMap();
        this.warehouseMap.forEach((material, stock) -> newMap.put(material, stock.getAmount()));
        return Map.copyOf(newMap);
    }

    public Map<Material, Stock> stock() {
        return Map.copyOf(this.warehouseMap);
    }

    public Collection<Material> storedMaterials() {
        return this.warehouseMap.keySet();
    }

    public int currentStockQuantity() {
        return this.warehouseMap.values().stream().mapToInt(Stock::getAmount).sum();
    }

    public TriState removeCompartment(Material material) {
        Stock stock = this.warehouseMap.get(material);
        if (stock == null) {
            return TriState.ALTERNATIVE_STATE;
        }
        WarehouseCompartmentEvent event = new WarehouseCompartmentEvent(this, EventAction.REMOVE, material, !Bukkit.isPrimaryThread());
        event.setCancelled(stock.getAmount() > 0);
        if (event.callEvent()) {
            this.warehouseMap.remove(material);
            return TriState.TRUE;
        }
        return TriState.FALSE;
    }

    public boolean hasCompartment(Material material) {
        return this.warehouseMap.containsKey(material);
    }

    public boolean hasCompartment(ItemStack itemStack) {
        if (itemStack.hasItemMeta()) {
            return false;
        }
        return this.warehouseMap.containsKey(itemStack.getType());
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.owner;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> save(DataSource dataSource) {
        return dataSource.saveWarehouse(this);
    }

    @Override
    public boolean isExpired() {
        return CachedObject.super.isExpired() && Bukkit.getPlayer((UUID)this.owner) == null;
    }

    public int stockWithInventory(Player player, Inventory inv, Material material, int amt) {
        int materialInInv = Util.getMaterialAmount(inv, material);
        if (materialInInv == 0 || amt < 0) {
            lng.entry(l -> l.warehouse().notEnoughMaterial(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material.toString())));
            return 0;
        }
        int toStock = Math.min(amt, materialInInv);
        int stockedAmt = this.stockItem(material, toStock);
        if (stockedAmt > 0) {
            inv.removeItem(new ItemStack[]{new ItemStack(material, stockedAmt)});
            lng.entry(l -> l.warehouse().addedItem(), (Audience)player, Couple.of("{amount}", String.valueOf(stockedAmt)), Couple.of("{material}", Util.formatEnumerator(material)), Couple.of("{stock}", String.valueOf(this.getQuantity(material))));
            return stockedAmt;
        }
        lng.entry(l -> l.warehouse().notEnoughStock(), (Audience)player, new Couple[0]);
        return 0;
    }

    @Nullable
    public ItemStack destockToInventory(Player player, Inventory inv, Material material, int amt) {
        int invAmt = Util.getAmountInvCanHold(inv, material);
        int toDestock = Math.min(amt, invAmt);
        if (invAmt == 0 || toDestock <= 0) {
            lng.entry(l -> l.warehouse().inventoryFull(), (Audience)player, new Couple[0]);
            return null;
        }
        ItemStack itemStack = this.destockItem(material, toDestock);
        if (itemStack != null) {
            inv.addItem(new ItemStack[]{itemStack});
            lng.entry(l -> l.warehouse().withdrewItem(), (Audience)player, Couple.of("{amount}", String.valueOf(itemStack.getAmount())), Couple.of("{material}", Util.formatEnumerator(material)), Couple.of("{stock}", String.valueOf(this.getQuantity(material))));
            return itemStack;
        }
        lng.entry(l -> l.warehouse().notEnoughMaterial(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material.toString())));
        return null;
    }

    public List<GuiItem> stockAsGuiItems(int truncate) {
        ArrayList<GuiItem> items = new ArrayList<GuiItem>();
        int i = 0;
        List<Stock> sortedStocks = this.warehouseMap.values().stream().sorted(Comparator.comparingLong(Stock::getLastUpdate).reversed()).toList();
        for (Stock stock : sortedStocks) {
            Material material = stock.getMaterial();
            GuiItem guiItem = GuiItem.builder().itemStack(b -> b.stringReplacements(Couple.of("{quantity}", String.valueOf(stock.getAmount())), Couple.of("{material}", Util.formatEnumerator(material.toString()))).material(material).displayName(guiCfg.warehouseGui().warehouseItem().name()).lore(guiCfg.warehouseGui().warehouseItem().lore())).action(e -> {
                if (e.isCancelled()) {
                    return;
                }
                Player player = (Player)e.getWhoClicked();
                PlayerInventory inv = player.getInventory();
                ItemStack clickedItem = e.getCurrentItem();
                switch (e.getClick()) {
                    case LEFT: {
                        int invAmt = Util.getAmountInvCanHold((Inventory)inv, material);
                        if (invAmt == 0) {
                            lng.entry(l -> l.warehouse().inventoryFull(), (Audience)player, new Couple[0]);
                            return;
                        }
                        ItemStack item = this.destockItem(material, 1);
                        if (item == null) {
                            lng.entry(l -> l.warehouse().notEnoughMaterial(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material.toString())));
                            break;
                        }
                        inv.addItem(new ItemStack[]{item});
                        break;
                    }
                    case RIGHT: {
                        int invAmt = Util.getAmountInvCanHold((Inventory)inv, material);
                        if (invAmt == 0) {
                            lng.entry(l -> l.warehouse().inventoryFull(), (Audience)player, new Couple[0]);
                            return;
                        }
                        ItemStack item = this.destockItem(material, 64);
                        if (item == null) {
                            lng.entry(l -> l.warehouse().notEnoughMaterial(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material.toString())));
                            break;
                        }
                        inv.addItem(new ItemStack[]{item});
                        break;
                    }
                    case SHIFT_LEFT: {
                        int invAmt = Util.getAmountInvCanHold((Inventory)inv, material);
                        if (invAmt == 0) {
                            lng.entry(l -> l.warehouse().inventoryFull(), (Audience)player, new Couple[0]);
                            return;
                        }
                        ItemStack item = this.destockItem(material, invAmt);
                        if (item != null) {
                            inv.addItem(new ItemStack[]{item});
                            break;
                        }
                        lng.entry(l -> l.warehouse().notEnoughMaterial(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material.toString())));
                        break;
                    }
                    case SHIFT_RIGHT: {
                        int invAmt = Util.getMaterialAmount((Inventory)inv, material);
                        if (invAmt == 0) {
                            lng.entry(l -> l.warehouse().notEnoughMaterial(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material.toString())));
                            return;
                        }
                        int diff = this.stockItem(material, invAmt);
                        if (diff > 0) {
                            inv.removeItem(new ItemStack[]{new ItemStack(material, diff)});
                            break;
                        }
                        lng.entry(l -> l.warehouse().notEnoughStock(), (Audience)player, new Couple[0]);
                    }
                }
                Util.editMeta(clickedItem, meta -> meta.lore(Text.mmlNoItalic(Util.replaceAll(guiCfg.warehouseGui().warehouseItem().lore(), "{quantity}", String.valueOf(stock.getAmount())), (TextColor)NamedTextColor.WHITE)));
            }).build();
            items.add(guiItem);
            if (truncate <= 0 || ++i < truncate) continue;
            break;
        }
        return items;
    }

    public String toString() {
        return "Warehouse{expire=" + this.expire + ", owner=" + String.valueOf(this.owner) + ", warehouseMap=" + String.valueOf(this.warehouseMap) + "}";
    }

    @Override
    @Generated
    public Long getExpire() {
        return this.expire;
    }

    @Override
    @Generated
    public void setExpire(Long expire) {
        this.expire = expire;
    }

    @Generated
    public UUID getOwner() {
        return this.owner;
    }
}

