/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.obj;

import com.google.common.base.Preconditions;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.IntPair;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public record VaultContentScanner(Collection<Vault> vaults, @Nullable IntPair range, @Nullable String who) {
    private static final IntPair RANGE_PER_PAGE = IntPair.of(1, 6);

    public VaultContentScanner(Collection<Vault> vaults, int page, @Nullable String who) {
        this(vaults, VaultContentScanner.rangeForPage(page), who);
    }

    public ResultCollection matchingVaults(String plainText) {
        String searchFor = plainText.toLowerCase().strip();
        List<Result> results = this.vaults.stream().map(vault -> {
            List<ItemStack> matches = Arrays.stream(vault.getInventory().getContents()).filter(Objects::nonNull).filter(item -> this.matchesSearch((ItemStack)item, searchFor)).collect(Collectors.toList());
            if (matches.isEmpty()) {
                return null;
            }
            return new Result((Vault)vault, matches, this.who);
        }).filter(Objects::nonNull).toList();
        return new ResultCollection(results, this.range, plainText, this.who);
    }

    private boolean matchesSearch(ItemStack itemStack, String searchFor) {
        return this.hasMatchingName(itemStack, searchFor) || this.hasMatchingMaterialName(itemStack, searchFor) || this.hasMatchingLore(itemStack, searchFor);
    }

    private boolean hasMatchingName(ItemStack itemStack, String plainText) {
        String searchFor = plainText.toLowerCase().strip();
        String plainItemName = PlainTextComponentSerializer.plainText().serialize(itemStack.effectiveName()).toLowerCase().strip();
        return plainItemName.contains(searchFor);
    }

    private boolean hasMatchingMaterialName(ItemStack itemStack, String plainText) {
        String searchFor = plainText.toLowerCase().strip().replace(" ", "_");
        String materialName = itemStack.getType().name().toLowerCase();
        return materialName.contains(searchFor);
    }

    private boolean hasMatchingLore(ItemStack itemStack, String plainText) {
        String searchFor = plainText.toLowerCase().strip();
        if (!itemStack.hasItemMeta() || !itemStack.getItemMeta().hasLore()) {
            return false;
        }
        List lore = (List)Preconditions.checkNotNull((Object)itemStack.getItemMeta().lore());
        for (Component loreLine : lore) {
            String plainLoreLine = PlainTextComponentSerializer.plainText().serialize(loreLine).toLowerCase().strip();
            if (!plainLoreLine.contains(searchFor)) continue;
            return true;
        }
        return false;
    }

    public static IntPair rangeForPage(int page) {
        int perPage = (Integer)RANGE_PER_PAGE.b();
        int start = (page - 1) * perPage + 1;
        int end = page * perPage;
        return IntPair.of(start, end);
    }

    public static int pageForRange(@Nullable IntPair range) {
        if (range == null) {
            return 1;
        }
        int perPage = (Integer)RANGE_PER_PAGE.b();
        return (int)Math.ceil((double)((Integer)range.a()).intValue() / (double)perPage);
    }

    public static class ResultCollection {
        private static final Lang lang = ConfigManager.get(Lang.class);
        private final List<Result> results;
        private final IntPair range;
        private final String query;
        @Nullable
        private final String who;
        private final Component previousPageComponent = lang.entry(l -> l.command().search().previousPage(), "\u00bb", new Couple[0]);
        private final Component nextPageComponent = lang.entry(l -> l.command().search().nextPage(), "\u00bb", new Couple[0]);

        public Component queryResultSummary() {
            if (this.query == null || this.query.isEmpty() || this.results.isEmpty()) {
                return (Component)Preconditions.checkNotNull((Object)lang.entry(l -> l.command().search().noResults(), true, Couple.of("{query}", this.query)));
            }
            int maxPages = (int)Math.ceil((double)this.totalItemsFound() / (double)((Integer)RANGE_PER_PAGE.b()).intValue());
            int page = Math.min(VaultContentScanner.pageForRange(this.range), maxPages == 0 ? 1 : maxPages);
            List<Component> resultsFormatted = this.resultsFormatted();
            Component previousPage = this.previousPageComponent.clickEvent(ClickEvent.runCommand((String)this.searchCommand(page - 1))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.previousPageComponent));
            Component nextPage = this.nextPageComponent.clickEvent(ClickEvent.runCommand((String)this.searchCommand(page + 1))).hoverEvent((HoverEventSource)HoverEvent.showText((Component)this.nextPageComponent));
            Component base = lang.entry(l -> lang.command().search().results(), true, Couple.of("{amount}", this.totalItemsFound()), Couple.of("{query}", this.query), Couple.of("{page}", page), Couple.of("{maxPages}", maxPages));
            return Util.replaceComponents(base, Couple.of("{results}", resultsFormatted), Couple.of("{previousPage}", previousPage), Couple.of("{nextPage}", nextPage));
        }

        public List<Component> resultsFormatted() {
            String format = lang.command().search().resultFormat();
            ArrayList<Component> resultsFormatted = new ArrayList<Component>();
            for (Result result : this.results) {
                List<Component> formattedItems = result.formatMatchingItems(format, result.getVault());
                resultsFormatted.addAll(formattedItems);
            }
            if (this.range != null) {
                int total = resultsFormatted.size();
                if (total == 0) {
                    return resultsFormatted;
                }
                int startIndex = Math.max((Integer)this.range.a() - 1, 0);
                int endIndex = Math.min((Integer)this.range.b(), total);
                if (startIndex >= total) {
                    int perPage = (Integer)RANGE_PER_PAGE.b();
                    startIndex = Math.max(total - perPage, 0);
                    endIndex = total;
                }
                endIndex = Math.max(endIndex, startIndex);
                return resultsFormatted.subList(startIndex, endIndex);
            }
            return resultsFormatted;
        }

        public int totalItemsFound() {
            return this.results.stream().mapToInt(result -> result.getMatchingItems().size()).sum();
        }

        private String searchCommand(int page) {
            return "malts search " + this.query + " -page " + page + (String)(this.who != null && !this.who.isEmpty() ? " -player " + this.who : "");
        }

        @Generated
        public ResultCollection(List<Result> results, IntPair range, String query, @Nullable String who) {
            this.results = results;
            this.range = range;
            this.query = query;
            this.who = who;
        }

        @Generated
        public List<Result> getResults() {
            return this.results;
        }

        @Generated
        public IntPair getRange() {
            return this.range;
        }

        @Generated
        public String getQuery() {
            return this.query;
        }
    }

    public static class Result {
        private final Vault vault;
        private final List<ItemStack> matchingItems;
        @Nullable
        private final String otherPlayer;

        public List<Component> formatMatchingItems(String format, Vault vault) {
            return this.matchingItems.stream().map(itemStack -> Util.replaceComponents(Text.mm(format), Couple.of("{itemName}", itemStack.effectiveName()), Couple.of("{amount}", String.valueOf(itemStack.getAmount())), Couple.of("{vaultName}", vault.getCustomName())).hoverEvent((HoverEventSource)itemStack.asHoverEvent()).clickEvent(ClickEvent.runCommand((String)this.vaultCommand()))).toList();
        }

        private String vaultCommand() {
            if (this.otherPlayer != null && !this.otherPlayer.isEmpty()) {
                return "malts vaultother " + this.otherPlayer + " " + this.vault.getId();
            }
            return "malts vaults " + this.vault.getId();
        }

        @Generated
        public Result(Vault vault, List<ItemStack> matchingItems, @Nullable String otherPlayer) {
            this.vault = vault;
            this.matchingItems = matchingItems;
            this.otherPlayer = otherPlayer;
        }

        @Generated
        public Vault getVault() {
            return this.vault;
        }

        @Generated
        public List<ItemStack> getMatchingItems() {
            return this.matchingItems;
        }
    }
}

