/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.importers;

import com.artillexstudios.axvaults.vaults.VaultManager;
import dev.jsinco.malts.importers.Importer;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.ClassUtil;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.inventory.ItemStack;

public class AxVaultsImporter
implements Importer {
    @Override
    public String name() {
        return "AxVaults";
    }

    @Override
    public boolean canImport() {
        return ClassUtil.classExists("com.artillexstudios.axvaults.AxVaults");
    }

    @Override
    public CompletableFuture<Map<UUID, Importer.Result>> importAll() {
        OfflinePlayer[] players = Bukkit.getOfflinePlayers();
        if (players.length == 0) {
            return CompletableFuture.completedFuture(Map.of());
        }
        List<CompletableFuture> futures = Arrays.stream(players).map(this::importVaults).toList();
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> futures.stream().map(CompletableFuture::join).collect(Collectors.toMap(Couple::a, Couple::b)));
    }

    private CompletableFuture<Couple<UUID, Importer.Result>> importVaults(OfflinePlayer offlinePlayer) {
        UUID uuid = offlinePlayer.getUniqueId();
        return ((CompletableFuture)VaultManager.getPlayer((OfflinePlayer)offlinePlayer).thenCompose(vaultPlayer -> {
            ConcurrentHashMap vaultMap = vaultPlayer.getVaultMap();
            if (vaultMap.isEmpty()) {
                return CompletableFuture.completedFuture(Couple.of(uuid, Importer.Result.NO_VAULTS_IN_OTHER_PLUGIN));
            }
            Map<Integer, ItemStack[]> inventories = vaultMap.entrySet().stream().filter(entry -> {
                ItemStack[] contents = ((com.artillexstudios.axvaults.vaults.Vault)entry.getValue()).getStorage().getContents();
                return contents != null && contents.length > 0;
            }).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((com.artillexstudios.axvaults.vaults.Vault)entry.getValue()).getStorage().getContents()));
            return DataSource.getInstance().getVaults(uuid).thenCompose(existing -> {
                if (!existing.isEmpty()) {
                    return CompletableFuture.completedFuture(Couple.of(uuid, Importer.Result.VAULTS_NOT_EMPTY));
                }
                return this.saveAllVaults(uuid, inventories).thenApply(v -> Couple.of(uuid, Importer.Result.SUCCESS));
            });
        })).exceptionally(error -> {
            Text.error("Failed to import vaults for " + String.valueOf(uuid), error);
            return Couple.of(uuid, Importer.Result.FAILED);
        });
    }

    private CompletableFuture<Void> saveAllVaults(UUID uuid, Map<Integer, ItemStack[]> inventories) {
        DataSource dataSource = DataSource.getInstance();
        CompletionStage<Object> chain = CompletableFuture.completedFuture(null);
        for (Map.Entry<Integer, ItemStack[]> entry : inventories.entrySet()) {
            int index = entry.getKey();
            ItemStack[] inv = entry.getValue();
            chain = chain.thenCompose(v -> dataSource.saveVault(new Vault(uuid, index, inv)).thenRun(() -> Text.log("Imported vault #" + index + " for " + String.valueOf(uuid))));
        }
        return chain;
    }
}

