/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.subcommands;

import com.google.common.base.Preconditions;
import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.gui.YourVaultsGui;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Util;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VaultsCommand
implements SubCommand {
    @Override
    public boolean execute(Malts plugin, CommandSender sender, String label, List<String> args) {
        Player player = (Player)sender;
        DataSource dataSource = DataSource.getInstance();
        MaltsPlayer maltsPlayer = dataSource.cachedObject(player.getUniqueId(), MaltsPlayer.class);
        Preconditions.checkNotNull((Object)maltsPlayer, (Object)"MaltsPlayer should not be null for online player.");
        if (args.isEmpty()) {
            YourVaultsGui yourVaultsGui = new YourVaultsGui(maltsPlayer);
            yourVaultsGui.open(player);
            return true;
        }
        int vaultId = Util.getInteger(args.getFirst(), 1);
        if (maltsPlayer.getCalculatedMaxVaults() < vaultId) {
            lng.entry(l -> l.vaults().noAccess(), (Audience)player, Couple.of("{id}", vaultId));
            return true;
        }
        dataSource.getVaultWithEconomy(player, vaultId, vault -> {
            vault.open(player);
            lng.entry(l -> l.vaults().opening(), (Audience)player, Couple.of("{id}", vaultId), Couple.of("{vaultName}", vault.getCustomName()));
        });
        return true;
    }

    @Override
    public List<String> tabComplete(Malts plugin, CommandSender sender, String label, List<String> args) {
        Player player = (Player)sender;
        DataSource dataSource = DataSource.getInstance();
        MaltsPlayer maltsPlayer = dataSource.cachedObject(player.getUniqueId(), MaltsPlayer.class);
        Preconditions.checkNotNull((Object)maltsPlayer, (Object)"MaltsPlayer should not be null for online player.");
        return IntStream.rangeClosed(1, maltsPlayer.getCalculatedMaxVaults()).mapToObj(String::valueOf).collect(Collectors.toList());
    }

    @Override
    public String name() {
        return "vaults";
    }

    @Override
    public String permission() {
        return "malts.command.vaults";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }
}

