/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.interfaces;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.utility.Couple;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SubCommandWrapper
implements TabExecutor {
    private final SubCommand subCommand;

    public SubCommandWrapper(SubCommand subCommand) {
        this.subCommand = subCommand;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        Lang lang = ConfigManager.get(Lang.class);
        if (this.subCommand.permission() != null && !sender.hasPermission(this.subCommand.permission())) {
            lang.entry(l -> l.command().base().noPermission(), (Audience)sender, new Couple[0]);
            return true;
        }
        if (this.subCommand.playerOnly() && !(sender instanceof Player)) {
            lang.entry(l -> l.command().base().playerOnly(), (Audience)sender, new Couple[0]);
            return true;
        }
        boolean result = this.subCommand.execute(Malts.getInstance(), sender, label, List.of(args));
        if (!result) {
            lang.entry(l -> l.command().base().invalidUsage(), (Audience)sender, new Couple[0]);
        }
        return result;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull @NotNull String @NotNull [] args) {
        if (this.subCommand.permission() != null && !sender.hasPermission(this.subCommand.permission())) {
            return null;
        }
        return this.subCommand.tabComplete(Malts.getInstance(), sender, label, List.of(args));
    }

    public String name() {
        return this.subCommand.name();
    }
}

