/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.utility;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.utility.Text;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class FileUtil {
    public static String readInternalResource(String path) {
        String string;
        block9: {
            ClassLoader loader = Malts.class.getClassLoader();
            InputStream inputStream = loader.getResourceAsStream(path);
            try {
                if (inputStream == null) {
                    throw new IllegalArgumentException("Resource not found: " + path + " (using classloader: " + String.valueOf(loader) + ")");
                }
                string = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read resource: " + path, e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    public static File readInternalFile(String path) {
        URL url = Malts.class.getResource(path);
        if (url == null) {
            throw new IllegalArgumentException("Resource not found: " + path);
        }
        return new File(url.getFile());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File[] listInternalFiles(String path) {
        File[] fileArray;
        URL url = FileUtil.class.getResource(path);
        if (url == null) {
            return new File[0];
        }
        if (url.getProtocol().equals("file")) {
            File dir = new File(url.toURI());
            File[] files = dir.listFiles();
            return files != null ? files : new File[]{};
        }
        if (!url.getProtocol().equals("jar")) return new File[0];
        String jarPath = url.getPath().substring(5, url.getPath().indexOf("!"));
        JarFile jar = new JarFile(URLDecoder.decode(jarPath, StandardCharsets.UTF_8));
        try {
            ArrayList<File> result = new ArrayList<File>();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().startsWith(path.substring(1) + "/") || entry.isDirectory()) continue;
                result.add(new File(entry.getName()));
            }
            fileArray = result.toArray(new File[0]);
        }
        catch (Throwable throwable) {
            try {
                try {
                    jar.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                Text.error("Failed to list internal files at path: " + path, e);
                return new File[0];
            }
        }
        jar.close();
        return fileArray;
    }

    public static File getInternalFile(String path) {
        URL url = FileUtil.class.getResource(path);
        if (url == null) {
            return null;
        }
        return new File(url.getFile());
    }
}

