/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.obj;

import com.google.common.collect.ImmutableList;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.GuiConfig;
import dev.jsinco.malts.gui.EditVaultGui;
import dev.jsinco.malts.gui.item.AbstractGuiItem;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Vault;
import dev.jsinco.malts.obj.VaultKey;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.ItemStacks;
import dev.jsinco.malts.utility.Util;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;

public class SnapshotVault
extends AbstractGuiItem {
    private static final GuiConfig cfg = ConfigManager.get(GuiConfig.class);
    private final VaultKey key;
    private final String customName;
    private final Material icon;
    private final ImmutableList<UUID> trustedPlayers;

    public SnapshotVault(UUID owner, int id, String customName, Material icon) {
        this(owner, id, customName, icon, (ImmutableList<UUID>)ImmutableList.of());
    }

    public SnapshotVault(UUID owner, int id, String customName, Material icon, ImmutableList<UUID> trustedPlayers) {
        this.key = VaultKey.of(owner, id);
        this.customName = customName != null && !customName.isEmpty() ? customName : "Vault #" + id;
        this.icon = icon != null && icon.isItem() ? icon : Material.CHEST;
        this.trustedPlayers = trustedPlayers;
    }

    public SnapshotVault(UUID owner, int id, String customName, Material icon, String trustedPlayers) {
        this.key = VaultKey.of(owner, id);
        this.customName = customName != null && !customName.isEmpty() ? customName : "Vault #" + id;
        this.icon = icon != null && icon.isItem() ? icon : Material.CHEST;
        List json = (List)Util.GSON.fromJson(trustedPlayers, Vault.LIST_UUID_TYPE_TOKEN);
        this.trustedPlayers = json != null ? ImmutableList.copyOf((Collection)json) : ImmutableList.of();
    }

    public CompletableFuture<Vault> toVault() {
        DataSource dataSource = DataSource.getInstance();
        return dataSource.getVault(this.key.owner(), this.key.id());
    }

    public void toVaultWithEconomy(Player player, Consumer<Vault> consumer) {
        DataSource dataSource = DataSource.getInstance();
        dataSource.getVaultWithEconomy(player, this.key.id(), consumer);
    }

    public boolean isTrusted(UUID uuid) {
        return this.trustedPlayers.contains((Object)uuid);
    }

    public boolean canAccess(Player player) {
        return player.getUniqueId() == this.key.owner() || this.trustedPlayers.contains((Object)player.getUniqueId()) || player.hasPermission(Vault.BYPASS_OPEN_VAULT_PERM);
    }

    @Override
    public ItemStack itemStack() {
        return ItemStacks.builder().stringReplacements(Couple.of("{vaultName}", this.customName), Couple.of("{id}", this.key.id())).displayName(cfg.yourVaultsGui().vaultItem().name()).material(this.icon).lore(cfg.yourVaultsGui().vaultItem().lore()).build();
    }

    @Override
    public void onClick(InventoryClickEvent event, ItemStack clickedItem) {
        if (!Util.hasPersistentKey(clickedItem, this.key())) {
            return;
        }
        boolean isLeftClick = event.isLeftClick();
        Player player = (Player)event.getWhoClicked();
        this.toVaultWithEconomy(player, vault -> {
            if (isLeftClick) {
                vault.open(player);
            } else {
                MaltsPlayer maltsPlayer = DataSource.getInstance().cachedObject(player.getUniqueId(), MaltsPlayer.class);
                EditVaultGui editVaultGui = new EditVaultGui((Vault)vault, maltsPlayer, player);
                editVaultGui.open(player);
            }
        });
    }

    public UUID getOwner() {
        return this.key.owner();
    }

    public int getId() {
        return this.key.id();
    }

    @Generated
    public VaultKey getKey() {
        return this.key;
    }

    @Generated
    public String getCustomName() {
        return this.customName;
    }

    @Generated
    public Material getIcon() {
        return this.icon;
    }

    @Generated
    public ImmutableList<UUID> getTrustedPlayers() {
        return this.trustedPlayers;
    }
}

