/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.gui.item;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.utility.Util;
import org.bukkit.NamespacedKey;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGuiItem {
    private ItemStack cachedItemStack;

    protected abstract ItemStack itemStack();

    public abstract void onClick(InventoryClickEvent var1, ItemStack var2);

    @Nullable
    public Integer index() {
        return null;
    }

    public final NamespacedKey key() {
        String name = this.getClass().getSimpleName() + "_" + System.identityHashCode(this);
        return Util.namespacedKey(name);
    }

    public final ItemStack getItemStack(boolean cached) {
        boolean shouldRebuild;
        boolean bl = shouldRebuild = !cached || this.cachedItemStack == null || Malts.isInvalidatedCachedGuiItems();
        if (shouldRebuild) {
            ItemStack itemStack = Util.setPersistentKey(this.itemStack(), this.key(), PersistentDataType.BOOLEAN, Boolean.valueOf(true));
            if (!cached) {
                return itemStack;
            }
            this.cachedItemStack = itemStack;
            Malts.setInvalidatedCachedGuiItems(false);
        }
        return this.cachedItemStack;
    }

    public final ItemStack getItemStack() {
        return this.getItemStack(true);
    }
}

