/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.enums;

import com.google.common.base.Preconditions;
import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Config;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.integration.external.CoreProtectIntegration;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Warehouse;
import dev.jsinco.malts.registry.Registry;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Executors;
import dev.jsinco.malts.utility.Util;
import io.papermc.paper.block.TileStateInventoryHolder;
import java.util.ArrayList;
import java.util.List;
import net.kyori.adventure.audience.Audience;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.player.PlayerAttemptPickupItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public enum WarehouseMode {
    AUTO_STORE(PlayerAttemptPickupItemEvent.class, (event, maltsPlayer, warehouse) -> {
        Item physicalItem = event.getItem();
        ItemStack itemStack = physicalItem.getItemStack();
        Material material = itemStack.getType();
        if (!warehouse.hasCompartment(itemStack)) {
            return;
        }
        Lang lang = ConfigManager.get(Lang.class);
        int deposited = warehouse.stockItem(material, itemStack.getAmount());
        int remainder = itemStack.getAmount() - deposited;
        if (deposited < 1) {
            return;
        }
        physicalItem.setCanMobPickup(false);
        physicalItem.setCanPlayerPickup(false);
        event.setCancelled(true);
        event.setFlyAtPlayer(true);
        Executors.delayedSync(1L, () -> {
            physicalItem.remove();
            if (remainder > 0) {
                itemStack.setAmount(remainder);
                physicalItem.getWorld().dropItem(physicalItem.getLocation(), itemStack);
            }
        });
        lang.actionBarEntry(l -> l.warehouse().autoStoredItem(), (Audience)event.getPlayer(), Couple.of("{material}", Util.formatEnumerator(material)), Couple.of("{amount}", deposited), Couple.of("{remainder}", remainder), Couple.of("{stock}", warehouse.getQuantity(material)));
    }),
    CLICK_TO_DEPOSIT(PlayerInteractEvent.class, (event, maltsPlayer, warehouse) -> {
        BlockState patt0$temp;
        Block clickedBlock = event.getClickedBlock();
        ItemStack itemInHand = event.getItem();
        Player player = event.getPlayer();
        Lang lang = ConfigManager.get(Lang.class);
        if (!(itemInHand != null && clickedBlock != null && warehouse.hasCompartment(itemInHand) && player.isSneaking() && (patt0$temp = clickedBlock.getState(false)) instanceof TileStateInventoryHolder)) {
            return;
        }
        TileStateInventoryHolder container = (TileStateInventoryHolder)patt0$temp;
        Material material = itemInHand.getType();
        Inventory inv = container.getInventory();
        int invAmt = Util.getAmountInvCanHold(inv, material);
        if (invAmt == 0) {
            lang.entry(l -> l.warehouse().containerFull(), (Audience)player, new Couple[0]);
            return;
        }
        ItemStack item = warehouse.destockItem(material, invAmt);
        if (item != null) {
            int amt = item.getAmount();
            inv.addItem(new ItemStack[]{item});
            CoreProtectIntegration coreProtectIntegration = Registry.INTEGRATIONS.get(CoreProtectIntegration.class);
            if (coreProtectIntegration != null) {
                coreProtectIntegration.logContainer(player, container);
            }
            lang.actionBarEntry(l -> l.warehouse().depositedItem(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material)), Couple.of("{amount}", amt), Couple.of("{stock}", warehouse.getQuantity(material)));
        } else {
            lang.actionBarEntry(l -> l.warehouse().notEnoughMaterial(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material.toString())));
        }
    }),
    AUTO_REPLENISH(List.of(BlockPlaceEvent.class, PlayerItemConsumeEvent.class), (event, maltsPlayer, warehouse) -> {
        EquipmentSlot hand;
        ItemStack originalItemStack;
        Player player;
        if (event instanceof BlockPlaceEvent) {
            BlockPlaceEvent e = (BlockPlaceEvent)event;
            player = e.getPlayer();
            originalItemStack = e.getItemInHand();
            hand = e.getHand();
        } else if (event instanceof PlayerItemConsumeEvent) {
            PlayerItemConsumeEvent e = (PlayerItemConsumeEvent)event;
            player = e.getPlayer();
            originalItemStack = e.getItem();
            hand = e.getHand();
        } else {
            throw new IllegalStateException("Unexpected event type.");
        }
        Material material = originalItemStack.getType();
        if (originalItemStack.getAmount() > 2 || !warehouse.hasCompartment(material) || player.getGameMode() == GameMode.CREATIVE) {
            return;
        }
        Executors.delayedSync(1L, () -> {
            ItemStack itemInHand = player.getInventory().getItem(hand);
            ItemStack item = warehouse.destockItem(material, itemInHand.getMaxStackSize() - itemInHand.getAmount());
            if (item == null) {
                return;
            }
            player.getInventory().addItem(new ItemStack[]{item});
            ConfigManager.get(Lang.class).actionBarEntry(l -> l.warehouse().replenishedItem(), (Audience)player, Couple.of("{material}", Util.formatEnumerator(material)), Couple.of("{amount}", item.getAmount()), Couple.of("{stock}", warehouse.getQuantity(material)));
        });
    }),
    NONE(List.of(), (event, maltsPlayer, warehouse) -> {});

    private final List<Class<? extends Event>> eventClasses;
    private final Handler<? extends Event> handler;

    private <T extends Event> WarehouseMode(Class<T> eventClass, Handler<T> handler) {
        this.eventClasses = List.of(eventClass);
        this.handler = handler;
    }

    private <T extends Event> WarehouseMode(List<Class<? extends Event>> eventClasses, Handler<T> handler) {
        this.eventClasses = eventClasses;
        this.handler = handler;
    }

    @Nullable
    public String getPermission() {
        if (this == NONE) {
            return null;
        }
        return "malts.warehouse.mode." + this.name().toLowerCase();
    }

    public <T extends Event> void handle(T event, MaltsPlayer maltsPlayer, Player player) {
        List<String> disabledWorlds = ConfigManager.get(Config.class).warehouse().disableModesInWorlds();
        if (this == NONE || disabledWorlds.contains(player.getWorld().getName()) || !this.eventClasses.contains(event.getClass())) {
            return;
        }
        if (!player.hasPermission(this.getPermission())) {
            WarehouseMode newMode = WarehouseMode.getNextMode(this, player);
            maltsPlayer.setWarehouseMode(newMode);
            return;
        }
        DataSource dataSource = DataSource.getInstance();
        Warehouse warehouse = dataSource.cachedObject(maltsPlayer.getUuid(), Warehouse.class);
        Preconditions.checkNotNull((Object)warehouse, (Object)"Warehouse is not cached.");
        this.handler.handle(event, maltsPlayer, warehouse);
    }

    public static List<WarehouseMode> getEnabledModes() {
        ArrayList<WarehouseMode> modes = new ArrayList<WarehouseMode>(ConfigManager.get(Config.class).warehouse().enabledModes());
        if (!modes.contains((Object)NONE)) {
            modes.add(NONE);
        }
        return modes;
    }

    public static WarehouseMode getNextMode(WarehouseMode mode, Player player) {
        WarehouseMode newMode = WarehouseMode.cycleMode(mode);
        while (newMode.getPermission() != null && !player.hasPermission(newMode.getPermission())) {
            newMode = WarehouseMode.cycleMode(newMode);
        }
        return newMode;
    }

    private static WarehouseMode cycleMode(WarehouseMode mode) {
        List<WarehouseMode> modes = WarehouseMode.getEnabledModes();
        int index = modes.indexOf((Object)mode);
        if (index == -1) {
            return NONE;
        }
        return modes.get((index + 1) % modes.size());
    }

    @FunctionalInterface
    public static interface Handler<T extends Event> {
        public void handle(T var1, MaltsPlayer var2, Warehouse var3);
    }
}

