/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.configuration.files;

import dev.jsinco.malts.configuration.OkaeriFile;
import dev.jsinco.malts.configuration.OkaeriFileName;
import dev.jsinco.malts.shaded.okaeri.configs.OkaeriConfig;
import dev.jsinco.malts.shaded.okaeri.configs.annotation.CustomKey;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import dev.jsinco.malts.utility.Util;
import java.util.List;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OkaeriFileName(dynamicFileName=true, dynamicFileNameKey="language", dynamicFileNameFormat="translations/%s.yml")
public class Lang
extends OkaeriFile {
    private String prefix;
    private String updateAvailable;
    private Warehouse warehouse = new Warehouse();
    private Vaults vaults = new Vaults();
    private Gui gui = new Gui();
    private Economy economy = new Economy();
    private Command command = new Command();

    @SafeVarargs
    @Nullable
    public final Component entry(@Nullable String entry, boolean prefix, Couple<String, Object> ... placeholders) {
        if (entry == null) {
            entry = "<red>Lang entry was not found.";
        } else if (entry.isEmpty()) {
            return null;
        }
        return Text.mm((prefix ? this.prefix : "") + Util.replace(entry, placeholders));
    }

    @NotNull
    public final Component entry(FunctionalLang functionalLang, String defaultValue, Couple<String, Object> ... placeholders) {
        String entry = functionalLang.get(this);
        if (entry == null || entry.isEmpty()) {
            entry = defaultValue;
        }
        return Text.mm(Util.replace(entry, placeholders));
    }

    @NotNull
    public final Component entry(@Nullable String entry, String defaultValue, Couple<String, Object> ... placeholders) {
        if (entry == null || entry.isEmpty()) {
            entry = defaultValue;
        }
        return Text.mm(Util.replace(entry, placeholders));
    }

    @SafeVarargs
    @Nullable
    public final Component entry(FunctionalLang functionalLang, boolean prefix, Couple<String, Object> ... placeholders) {
        String entry = functionalLang.get(this);
        if (entry == null) {
            entry = "<red>Lang entry was not found.";
        } else if (entry.isEmpty()) {
            return null;
        }
        return Text.mm((prefix ? this.prefix : "") + Util.replace(entry, placeholders));
    }

    @SafeVarargs
    @Nullable
    public final Component entry(FunctionalLang functionalLang, Audience receiver, Couple<String, Object> ... placeholders) {
        Component comp = this.entry(functionalLang, true, placeholders);
        if (comp != null) {
            receiver.sendMessage(comp);
        }
        return comp;
    }

    @SafeVarargs
    @Nullable
    public final Component entry(FunctionalLang functionalLang, List<Audience> receivers, Couple<String, Object> ... placeholders) {
        Component comp = this.entry(functionalLang, true, placeholders);
        if (comp != null) {
            receivers.forEach(receiver -> receiver.sendMessage(comp));
        }
        return comp;
    }

    @SafeVarargs
    @Nullable
    public final Component actionBarEntry(FunctionalLang functionalLang, Audience receiver, Couple<String, Object> ... placeholders) {
        Component comp = this.entry(functionalLang, false, placeholders);
        if (comp != null) {
            receiver.sendActionBar(comp);
        }
        return comp;
    }

    @Override
    public String name() {
        return "lang.yml";
    }

    @Generated
    public String prefix() {
        return this.prefix;
    }

    @Generated
    public String updateAvailable() {
        return this.updateAvailable;
    }

    @Generated
    public Warehouse warehouse() {
        return this.warehouse;
    }

    @Generated
    public Vaults vaults() {
        return this.vaults;
    }

    @Generated
    public Gui gui() {
        return this.gui;
    }

    @Generated
    public Economy economy() {
        return this.economy;
    }

    @Generated
    public Command command() {
        return this.command;
    }

    public static class Warehouse
    extends OkaeriConfig {
        private String notEnoughMaterial;
        private String notEnoughStock;
        private String inventoryFull;
        private String containerFull;
        private String removedCompartment;
        private String cannotRemoveCompartment;
        private String addedCompartment;
        private String compartmentAlreadyExists;
        private String compartmentDoesNotExist;
        private String changedMode;
        private String replenishedItem;
        private String autoStoredItem;
        private String depositedItem;
        private String cannotDepositItem;
        private String blacklistedItem;
        private String addedItem;
        private String withdrewItem;

        @Generated
        public String notEnoughMaterial() {
            return this.notEnoughMaterial;
        }

        @Generated
        public String notEnoughStock() {
            return this.notEnoughStock;
        }

        @Generated
        public String inventoryFull() {
            return this.inventoryFull;
        }

        @Generated
        public String containerFull() {
            return this.containerFull;
        }

        @Generated
        public String removedCompartment() {
            return this.removedCompartment;
        }

        @Generated
        public String cannotRemoveCompartment() {
            return this.cannotRemoveCompartment;
        }

        @Generated
        public String addedCompartment() {
            return this.addedCompartment;
        }

        @Generated
        public String compartmentAlreadyExists() {
            return this.compartmentAlreadyExists;
        }

        @Generated
        public String compartmentDoesNotExist() {
            return this.compartmentDoesNotExist;
        }

        @Generated
        public String changedMode() {
            return this.changedMode;
        }

        @Generated
        public String replenishedItem() {
            return this.replenishedItem;
        }

        @Generated
        public String autoStoredItem() {
            return this.autoStoredItem;
        }

        @Generated
        public String depositedItem() {
            return this.depositedItem;
        }

        @Generated
        public String cannotDepositItem() {
            return this.cannotDepositItem;
        }

        @Generated
        public String blacklistedItem() {
            return this.blacklistedItem;
        }

        @Generated
        public String addedItem() {
            return this.addedItem;
        }

        @Generated
        public String withdrewItem() {
            return this.withdrewItem;
        }
    }

    public static class Vaults
    extends OkaeriConfig {
        private String opening;
        private String nameChanged;
        private String noAccess;
        private String alreadyOpen;
        private String trustListMaxed;
        private String playerNeverOnServer;
        private String playerTrusted;
        private String playerUntrusted;
        private String playerNotTrusted;
        private String noVaultsFound;
        private String noVaultsAccessible;
        private String noVaultFound;
        private String vaultDeleted;
        private String vaultNameTooLong;
        private String transferred;
        private String cannotTransfer;
        private String iconChanged;

        @Generated
        public String opening() {
            return this.opening;
        }

        @Generated
        public String nameChanged() {
            return this.nameChanged;
        }

        @Generated
        public String noAccess() {
            return this.noAccess;
        }

        @Generated
        public String alreadyOpen() {
            return this.alreadyOpen;
        }

        @Generated
        public String trustListMaxed() {
            return this.trustListMaxed;
        }

        @Generated
        public String playerNeverOnServer() {
            return this.playerNeverOnServer;
        }

        @Generated
        public String playerTrusted() {
            return this.playerTrusted;
        }

        @Generated
        public String playerUntrusted() {
            return this.playerUntrusted;
        }

        @Generated
        public String playerNotTrusted() {
            return this.playerNotTrusted;
        }

        @Generated
        public String noVaultsFound() {
            return this.noVaultsFound;
        }

        @Generated
        public String noVaultsAccessible() {
            return this.noVaultsAccessible;
        }

        @Generated
        public String noVaultFound() {
            return this.noVaultFound;
        }

        @Generated
        public String vaultDeleted() {
            return this.vaultDeleted;
        }

        @Generated
        public String vaultNameTooLong() {
            return this.vaultNameTooLong;
        }

        @Generated
        public String transferred() {
            return this.transferred;
        }

        @Generated
        public String cannotTransfer() {
            return this.cannotTransfer;
        }

        @Generated
        public String iconChanged() {
            return this.iconChanged;
        }
    }

    public static class Gui
    extends OkaeriConfig {
        private String firstPage;
        private String lastPage;
        private String viewExpired;
        private String promptInputTimeOut;

        @Generated
        public String firstPage() {
            return this.firstPage;
        }

        @Generated
        public String lastPage() {
            return this.lastPage;
        }

        @Generated
        public String viewExpired() {
            return this.viewExpired;
        }

        @Generated
        public String promptInputTimeOut() {
            return this.promptInputTimeOut;
        }
    }

    public static class Economy
    extends OkaeriConfig {
        private Vaults vaults = new Vaults();

        @Generated
        public Vaults vaults() {
            return this.vaults;
        }

        public static class Vaults
        extends OkaeriConfig {
            private String created;
            private String cannotAffordCreation;
            private String accessed;
            private String cannotAffordAccess;

            @Generated
            public String created() {
                return this.created;
            }

            @Generated
            public String cannotAffordCreation() {
                return this.cannotAffordCreation;
            }

            @Generated
            public String accessed() {
                return this.accessed;
            }

            @Generated
            public String cannotAffordAccess() {
                return this.cannotAffordAccess;
            }
        }
    }

    public static class Command
    extends OkaeriConfig {
        private String help;
        private Base base = new Base();
        private Max max = new Max();
        @CustomKey(value="import")
        private Import _import = new Import();
        private VaultOther vaultOther = new VaultOther();
        private Reload reload = new Reload();
        private QuickReturn quickReturn = new QuickReturn();
        private Search search = new Search();

        @Generated
        public String help() {
            return this.help;
        }

        @Generated
        public Base base() {
            return this.base;
        }

        @Generated
        public Max max() {
            return this.max;
        }

        @Generated
        public Import _import() {
            return this._import;
        }

        @Generated
        public VaultOther vaultOther() {
            return this.vaultOther;
        }

        @Generated
        public Reload reload() {
            return this.reload;
        }

        @Generated
        public QuickReturn quickReturn() {
            return this.quickReturn;
        }

        @Generated
        public Search search() {
            return this.search;
        }

        public static class Base
        extends OkaeriConfig {
            private String unknownCommand;
            private String playerOnly;
            private String noPermission;
            private String invalidUsage;

            @Generated
            public String unknownCommand() {
                return this.unknownCommand;
            }

            @Generated
            public String playerOnly() {
                return this.playerOnly;
            }

            @Generated
            public String noPermission() {
                return this.noPermission;
            }

            @Generated
            public String invalidUsage() {
                return this.invalidUsage;
            }
        }

        public static class Max
        extends OkaeriConfig {
            private String invalidType;
            private String success;

            @Generated
            public String invalidType() {
                return this.invalidType;
            }

            @Generated
            public String success() {
                return this.success;
            }
        }

        public static class Import
        extends OkaeriConfig {
            private String cannotImport;
            private String startImport;
            private String importComplete;
            private String failedImport;
            private String confirmImport;

            @Generated
            public String cannotImport() {
                return this.cannotImport;
            }

            @Generated
            public String startImport() {
                return this.startImport;
            }

            @Generated
            public String importComplete() {
                return this.importComplete;
            }

            @Generated
            public String failedImport() {
                return this.failedImport;
            }

            @Generated
            public String confirmImport() {
                return this.confirmImport;
            }
        }

        public static class VaultOther
        extends OkaeriConfig {
            private String noVaultFound;

            @Generated
            public String noVaultFound() {
                return this.noVaultFound;
            }
        }

        public static class Reload
        extends OkaeriConfig {
            private String success;
            private String failed;
            private String newDatabaseDriverSet;

            @Generated
            public String success() {
                return this.success;
            }

            @Generated
            public String failed() {
                return this.failed;
            }

            @Generated
            public String newDatabaseDriverSet() {
                return this.newDatabaseDriverSet;
            }
        }

        public static class QuickReturn
        extends OkaeriConfig {
            private String success;
            private String failed;

            @Generated
            public String success() {
                return this.success;
            }

            @Generated
            public String failed() {
                return this.failed;
            }
        }

        public static class Search
        extends OkaeriConfig {
            private String noResults;
            private String resultFormat;
            private String results;
            private String previousPage;
            private String nextPage;
            private String playerNotFound;
            private String noAccessibleVaults;

            @Generated
            public String noResults() {
                return this.noResults;
            }

            @Generated
            public String resultFormat() {
                return this.resultFormat;
            }

            @Generated
            public String results() {
                return this.results;
            }

            @Generated
            public String previousPage() {
                return this.previousPage;
            }

            @Generated
            public String nextPage() {
                return this.nextPage;
            }

            @Generated
            public String playerNotFound() {
                return this.playerNotFound;
            }

            @Generated
            public String noAccessibleVaults() {
                return this.noAccessibleVaults;
            }
        }
    }

    public static interface FunctionalLang {
        public String get(Lang var1);
    }
}

