/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.configuration;

import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.OkaeriFileName;
import dev.jsinco.malts.registry.RegistryItem;
import dev.jsinco.malts.shaded.okaeri.configs.OkaeriConfig;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Text;
import java.nio.file.Path;

public class OkaeriFile
extends OkaeriConfig
implements RegistryItem {
    public String getFileName() {
        return this.getFileName(true);
    }

    public String getFileName(boolean dynamicFileName) {
        OkaeriFileName annotation = this.getClass().getAnnotation(OkaeriFileName.class);
        if (annotation == null) {
            throw new IllegalStateException("OkaeriFile must be annotated with @OkaeriFileName");
        }
        return annotation.dynamicFileName() && dynamicFileName ? this.dynamicFileName(annotation) : annotation.value();
    }

    private String dynamicFileName(OkaeriFileName annotation) {
        OkaeriFile config = ConfigManager.get(annotation.dynamicFileNameHolder());
        String value = config.get(annotation.dynamicFileNameKey(), String.class);
        if (value != null) {
            return String.format(annotation.dynamicFileNameFormat(), value);
        }
        return null;
    }

    public boolean isDynamicFileName() {
        OkaeriFileName annotation = this.getClass().getAnnotation(OkaeriFileName.class);
        return annotation != null && annotation.dynamicFileName();
    }

    public void reload() {
        Path bindFile = DataSource.DATA_FOLDER.resolve(this.getFileName(true));
        if (!this.getBindFile().equals(bindFile)) {
            this.setBindFile(bindFile);
        }
        this.load(true);
        Text.debug("Finished reloading configuration file: " + this.getFileName());
    }

    @Override
    public String name() {
        return this.getFileName(false);
    }
}

