/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.gui.item;

import dev.jsinco.malts.gui.item.AbstractGuiItem;
import dev.jsinco.malts.gui.item.GuiIndex;
import dev.jsinco.malts.gui.item.GuiItemStackBuilder;
import dev.jsinco.malts.utility.ItemStacks;
import dev.jsinco.malts.utility.Util;
import lombok.Generated;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GuiItem
extends AbstractGuiItem {
    private final GuiItemStackBuilder itemStack;
    private final GuiItemAction action;
    private final GuiIndex index;

    public GuiItem(GuiItemStackBuilder itemStack, GuiItemAction action, @Nullable GuiIndex index) {
        this.itemStack = itemStack;
        this.action = action;
        this.index = index;
    }

    @Override
    public ItemStack itemStack() {
        return this.itemStack.create(ItemStacks.builder()).build();
    }

    @Override
    public void onClick(InventoryClickEvent event, ItemStack clickedItem) {
        if (Util.hasPersistentKey(clickedItem, this.key())) {
            this.action.onClick(event);
        }
    }

    @Override
    public Integer index() {
        if (this.index == null) {
            return null;
        }
        return this.index.getIndex();
    }

    @Generated
    public static GuiItemBuilder builder() {
        return new GuiItemBuilder();
    }

    @FunctionalInterface
    public static interface GuiItemAction {
        public void onClick(InventoryClickEvent var1);
    }

    @Generated
    public static class GuiItemBuilder {
        @Generated
        private GuiItemStackBuilder itemStack;
        @Generated
        private GuiItemAction action;
        @Generated
        private GuiIndex index;

        @Generated
        GuiItemBuilder() {
        }

        @Generated
        public GuiItemBuilder itemStack(GuiItemStackBuilder itemStack) {
            this.itemStack = itemStack;
            return this;
        }

        @Generated
        public GuiItemBuilder action(GuiItemAction action) {
            this.action = action;
            return this;
        }

        @Generated
        public GuiItemBuilder index(GuiIndex index) {
            this.index = index;
            return this;
        }

        @Generated
        public GuiItem build() {
            return new GuiItem(this.itemStack, this.action, this.index);
        }

        @Generated
        public String toString() {
            return "GuiItem.GuiItemBuilder(itemStack=" + String.valueOf(this.itemStack) + ", action=" + String.valueOf(this.action) + ", index=" + String.valueOf(this.index) + ")";
        }
    }
}

