/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.interfaces;

import dev.jsinco.malts.utility.Couple;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArgumentFlagReader {
    private static final String FLAG_PREFIX = "-";
    private static final String DEFAULT_FLAG_VALUE = "true";
    private final Map<String, String> flags;
    private final List<String> newArguments;
    private CastHandler extraCasts;

    public ArgumentFlagReader(List<String> args) {
        Couple<Map<String, String>, List<String>> parsed = ArgumentFlagReader.parseArgs(args);
        this.flags = parsed.getFirst();
        this.newArguments = parsed.getSecond();
    }

    public ArgumentFlagReader(List<String> args, CastHandler extraCasts) {
        this(args);
        this.extraCasts = extraCasts;
    }

    @Nullable
    public String getFlagValue(String flagName) {
        return this.flags.get(flagName);
    }

    @NotNull
    public <T> T getFlagValueAs(String flagName, T defaultValue, Class<T> clazz) throws ClassCastException {
        T casted;
        String value = this.flags.get(flagName);
        if (value == null) {
            return defaultValue;
        }
        if (clazz == String.class) {
            return clazz.cast(value);
        }
        if (clazz == Integer.class) {
            return clazz.cast(Integer.parseInt(value));
        }
        if (clazz == Boolean.class) {
            return clazz.cast(Boolean.parseBoolean(value));
        }
        if (clazz == Double.class) {
            return clazz.cast(Double.parseDouble(value));
        }
        if (clazz == Float.class) {
            return clazz.cast(Float.valueOf(Float.parseFloat(value)));
        }
        if (clazz == Long.class) {
            return clazz.cast(Long.parseLong(value));
        }
        if (this.extraCasts != null && (casted = this.extraCasts.handle(value, clazz)) != null) {
            return casted;
        }
        return defaultValue;
    }

    private static Couple<Map<String, String>, List<String>> parseArgs(List<String> args) {
        HashMap<String, String> flags = new HashMap<String, String>();
        ArrayList<String> newArguments = new ArrayList<String>();
        ArrayList<String> argList = new ArrayList<String>(args);
        for (int i = 0; i < argList.size(); ++i) {
            String arg = (String)argList.get(i);
            if (arg.startsWith(FLAG_PREFIX) && arg.length() > 1) {
                String flagName = arg.substring(1);
                String flagValue = DEFAULT_FLAG_VALUE;
                if (i + 1 < argList.size() && !((String)argList.get(i + 1)).startsWith(FLAG_PREFIX)) {
                    flagValue = (String)argList.get(i + 1);
                    ++i;
                }
                flags.put(flagName, flagValue);
                continue;
            }
            newArguments.add(arg);
        }
        return Couple.of(flags, newArguments);
    }

    @Generated
    public Map<String, String> getFlags() {
        return this.flags;
    }

    @Generated
    public List<String> getNewArguments() {
        return this.newArguments;
    }

    @Generated
    public CastHandler getExtraCasts() {
        return this.extraCasts;
    }

    @Generated
    public void setExtraCasts(CastHandler extraCasts) {
        this.extraCasts = extraCasts;
    }

    public static interface CastHandler {
        @Nullable
        public <T> T handle(String var1, Class<T> var2);
    }
}

