/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.events;

import dev.jsinco.malts.configuration.ConfigManager;
import dev.jsinco.malts.configuration.files.Lang;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Text;
import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import lombok.Generated;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.jetbrains.annotations.Nullable;

public class ChatPromptInputListener
implements Listener {
    private static final Queue<ChatInputCallback> QUEUED_CHAT_PROMPTS = new ConcurrentLinkedQueue<ChatInputCallback>();

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onAsyncChat(AsyncChatEvent event) {
        if (QUEUED_CHAT_PROMPTS.isEmpty()) {
            return;
        }
        Player player = event.getPlayer();
        QUEUED_CHAT_PROMPTS.removeIf(callback -> {
            if (callback.isTimedOut()) {
                return true;
            }
            if (callback.uuid.equals(player.getUniqueId())) {
                String input = PlainTextComponentSerializer.plainText().serialize(event.originalMessage());
                event.setCancelled(true);
                if (!input.equals("cancel")) {
                    callback.handler.handle(input);
                } else {
                    callback.cancelled.run();
                }
                return true;
            }
            return false;
        });
    }

    public static class ChatInputCallback {
        private static final long TIMEOUT = 30000L;
        private final UUID uuid;
        private final long timestamp;
        private final ChatInputCallbackHandler handler;
        private final Runnable cancelled;

        public static ChatInputCallback of(HumanEntity player, @Nullable Title title, @Nullable String msg, ChatInputCallbackHandler handler, Runnable cancelled) {
            if (title != null) {
                player.showTitle(title);
            }
            if (msg != null) {
                Text.msg((CommandSender)player, msg);
            }
            ChatInputCallback chatInputCallback = new ChatInputCallback(player.getUniqueId(), System.currentTimeMillis(), handler, cancelled);
            QUEUED_CHAT_PROMPTS.add(chatInputCallback);
            return chatInputCallback;
        }

        public boolean isTimedOut() {
            boolean bool = System.currentTimeMillis() - this.timestamp >= 30000L;
            Player player = this.player();
            if (bool && player != null) {
                ConfigManager.get(Lang.class).entry(l -> l.gui().promptInputTimeOut(), (CommandSender)player, new Couple[0]);
                if (this.cancelled != null) {
                    this.cancelled.run();
                }
            }
            return bool;
        }

        @Nullable
        public Player player() {
            return Bukkit.getPlayer((UUID)this.uuid);
        }

        public boolean equals(Object object) {
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ChatInputCallback that = (ChatInputCallback)object;
            return Objects.equals(this.uuid, that.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.uuid, this.timestamp);
        }

        @Generated
        private ChatInputCallback(UUID uuid, long timestamp, ChatInputCallbackHandler handler, Runnable cancelled) {
            this.uuid = uuid;
            this.timestamp = timestamp;
            this.handler = handler;
            this.cancelled = cancelled;
        }

        public static interface ChatInputCallbackHandler {
            public void handle(String var1);
        }
    }
}

