/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.configuration;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.shaded.okaeri.configs.OkaeriConfig;
import dev.jsinco.malts.utility.Text;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.Map;
import org.yaml.snakeyaml.Yaml;

public final class NullKeyMerger {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends OkaeriConfig> boolean mergeWithInternalDefaults(T config, Path bindFile) {
        try {
            String resourcePath = NullKeyMerger.constructResourcePath(bindFile);
            try (InputStream in = Malts.class.getResourceAsStream(resourcePath);){
                if (in == null) {
                    boolean bl = false;
                    return bl;
                }
                Yaml yaml = new Yaml();
                Map internalData = (Map)yaml.load((Reader)new InputStreamReader(in));
                if (internalData == null) return false;
                boolean updated = NullKeyMerger.mergeNullValues(config, internalData);
                if (updated) {
                    config.save();
                }
                boolean bl = updated;
                return bl;
            }
        }
        catch (Exception e) {
            Text.error("Failed to merge null keys for config: " + String.valueOf(bindFile), e);
        }
        return false;
    }

    private static String constructResourcePath(Path bindFile) {
        String resourcePath = "/" + bindFile.getFileName().toString();
        if (bindFile.getParent() != null && bindFile.getParent().getFileName() != null) {
            resourcePath = "/" + bindFile.getParent().getFileName().toString() + "/" + bindFile.getFileName().toString();
        }
        return resourcePath;
    }

    private static boolean mergeNullValues(Object target, Map<String, Object> defaults) {
        boolean updated = false;
        for (Map.Entry<String, Object> entry : defaults.entrySet()) {
            String key = entry.getKey();
            Object defaultValue = entry.getValue();
            try {
                Field field = NullKeyMerger.findField(target.getClass(), key);
                if (field == null) continue;
                field.setAccessible(true);
                Object currentValue = field.get(target);
                if (currentValue == null && defaultValue != null) {
                    if (defaultValue instanceof Map) {
                        Object nestedConfig = field.getType().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        NullKeyMerger.mergeNullValues(nestedConfig, (Map)defaultValue);
                        field.set(target, nestedConfig);
                    } else {
                        field.set(target, defaultValue);
                    }
                    updated = true;
                    continue;
                }
                if (currentValue == null || !(defaultValue instanceof Map) || !OkaeriConfig.class.isAssignableFrom(field.getType())) continue;
                boolean nestedUpdated = NullKeyMerger.mergeNullValues(currentValue, (Map)defaultValue);
                updated = updated || nestedUpdated;
            }
            catch (Exception exception) {}
        }
        return updated;
    }

    private static Field findField(Class<?> clazz, String fieldName) {
        while (clazz != null && clazz != Object.class) {
            try {
                return clazz.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }
}

