/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.subcommands;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.gui.WarehouseGui;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Warehouse;
import dev.jsinco.malts.storage.DataSource;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WarehouseAdminCommand
implements SubCommand {
    @Override
    public boolean execute(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (args.isEmpty()) {
            return false;
        }
        Player player = (Player)sender;
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args.getFirst());
        DataSource dataSource = DataSource.getInstance();
        CompletableFuture<MaltsPlayer> playerFuture = dataSource.cacheObjectWithDefaultExpire(dataSource.getMaltsPlayer(target.getUniqueId()));
        CompletableFuture<Warehouse> warehouseFuture = dataSource.cacheObjectWithDefaultExpire(dataSource.getWarehouse(target.getUniqueId()));
        CompletableFuture.allOf(playerFuture, warehouseFuture).thenRunAsync(() -> {
            MaltsPlayer maltsPlayer = (MaltsPlayer)playerFuture.join();
            Warehouse warehouse = (Warehouse)warehouseFuture.join();
            WarehouseGui warehouseGui = new WarehouseGui(warehouse, maltsPlayer);
            warehouseGui.open(player);
        });
        return true;
    }

    @Override
    public List<String> tabComplete(Malts plugin, CommandSender sender, String label, List<String> args) {
        return null;
    }

    @Override
    public String permission() {
        return "malts.command.warehouseadmin";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String name() {
        return "warehouseadmin";
    }
}

