/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.subcommands;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.gui.WarehouseGui;
import dev.jsinco.malts.obj.MaltsPlayer;
import dev.jsinco.malts.obj.Warehouse;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import dev.jsinco.malts.utility.Util;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;

public class WarehouseCommand
implements SubCommand {
    @Override
    public boolean execute(Malts plugin, CommandSender sender, String label, List<String> args) {
        Player player = (Player)sender;
        DataSource dataSource = DataSource.getInstance();
        Warehouse warehouse = dataSource.cachedObject(player.getUniqueId(), Warehouse.class);
        MaltsPlayer maltsPlayer = dataSource.cachedObject(player.getUniqueId(), MaltsPlayer.class);
        if (args.isEmpty()) {
            WarehouseGui warehouseGui = new WarehouseGui(warehouse, maltsPlayer);
            warehouseGui.open(player);
            return true;
        }
        if (args.size() < 3) {
            return false;
        }
        ArgOption option = Util.getEnum(args.getFirst(), ArgOption.class);
        if (option == null) {
            return false;
        }
        Material material = Util.getEnum(args.get(1), Material.class);
        int amount = Util.getInteger(args.get(2), 0);
        if (material == null || !material.isItem()) {
            lng.entry(l -> l.warehouse().blacklistedItem(), (CommandSender)player, Couple.of("{material}", Util.formatEnumerator(args.get(1))));
            return true;
        }
        if (amount <= 0) {
            lng.entry(l -> l.warehouse().notEnoughMaterial(), (CommandSender)player, Couple.of("{material}", Util.formatEnumerator(material)));
            return true;
        }
        option.getExecutor().handle(plugin, player, maltsPlayer, warehouse, material, amount);
        return true;
    }

    @Override
    public List<String> tabComplete(Malts plugin, CommandSender sender, String label, List<String> args) {
        Player player = (Player)sender;
        DataSource dataSource = DataSource.getInstance();
        Warehouse warehouse = dataSource.cachedObject(player.getUniqueId(), Warehouse.class);
        Objects.requireNonNull(warehouse);
        return switch (args.size()) {
            case 1 -> Arrays.stream(ArgOption.values()).map(Enum::toString).map(String::toLowerCase).toList();
            case 2 -> warehouse.storedMaterials().stream().map(it -> it.toString().toLowerCase()).toList();
            case 3 -> Util.tryGetNextNumberArg(args.get(2));
            default -> List.of();
        };
    }

    @Override
    public String name() {
        return "warehouse";
    }

    @Override
    public String permission() {
        return "malts.command.warehouse";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    static enum ArgOption {
        DEPOSIT((plugin, player, maltsPlayer, warehouse, material, amount) -> {
            if (warehouse.hasCompartment(material)) {
                warehouse.stockWithInventory(player, (Inventory)player.getInventory(), material, amount);
            } else {
                SubCommand.lng.entry(l -> l.warehouse().compartmentDoesNotExist(), (CommandSender)player, Couple.of("{material}", Util.formatEnumerator(material)));
            }
        }),
        WITHDRAW((plugin, player, maltsPlayer, warehouse, material, amount) -> {
            if (warehouse.hasCompartment(material)) {
                warehouse.destockToInventory(player, (Inventory)player.getInventory(), material, amount);
            } else {
                SubCommand.lng.entry(l -> l.warehouse().compartmentDoesNotExist(), (CommandSender)player, Couple.of("{material}", Util.formatEnumerator(material)));
            }
        });

        private final Handler executor;

        private ArgOption(Handler executor) {
            this.executor = executor;
        }

        public Handler getExecutor() {
            return this.executor;
        }

        private static interface Handler {
            public void handle(Malts var1, Player var2, MaltsPlayer var3, Warehouse var4, Material var5, int var6);
        }
    }
}

