/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.malts.commands.subcommands;

import dev.jsinco.malts.Malts;
import dev.jsinco.malts.commands.interfaces.SubCommand;
import dev.jsinco.malts.obj.CachedObject;
import dev.jsinco.malts.storage.DataSource;
import dev.jsinco.malts.utility.Couple;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class VaultNameCommand
implements SubCommand {
    @Override
    public boolean execute(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (args.isEmpty()) {
            return false;
        }
        Player player = (Player)sender;
        String vaultName = args.getFirst();
        DataSource dataSource = DataSource.getInstance();
        dataSource.getVault(player.getUniqueId(), vaultName).thenAccept(vault -> {
            if (vault == null) {
                lng.entry(l -> l.vaults().noVaultFound(), (CommandSender)player, new Couple[0]);
                return;
            }
            vault.open(player);
            lng.entry(l -> l.vaults().opening(), (CommandSender)player, Couple.of("{vaultName}", vault.getCustomName()));
        });
        return true;
    }

    @Override
    public List<String> tabComplete(Malts plugin, CommandSender sender, String label, List<String> args) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        DataSource dataSource = DataSource.getInstance();
        CachedVaultNames cachedVaultNames = dataSource.cachedObject(player.getUniqueId(), CachedVaultNames.class);
        if (cachedVaultNames == null) {
            CompletionStage future = dataSource.getVaultNames(player.getUniqueId()).thenApply(vaultNames -> new CachedVaultNames(player.getUniqueId(), (List<String>)vaultNames));
            dataSource.cacheObject(future, 60000L).thenAccept(cached -> {});
            return List.of("...");
        }
        return cachedVaultNames.getVaultNames();
    }

    @Override
    public String permission() {
        return "malts.command.vaultname";
    }

    @Override
    public boolean playerOnly() {
        return true;
    }

    @Override
    public String name() {
        return "vaultname";
    }

    public static class CachedVaultNames
    implements CachedObject {
        private final UUID owner;
        private final List<String> vaultNames;
        private Long expire;

        public CachedVaultNames(UUID owner, List<String> vaultNames) {
            this.owner = owner;
            this.vaultNames = vaultNames;
        }

        @Override
        public UUID getUuid() {
            return this.owner;
        }

        @Override
        @Nullable
        public Long getExpire() {
            return this.expire;
        }

        @Override
        public void setExpire(@Nullable Long expire) {
            this.expire = expire;
        }

        @Override
        public CompletableFuture<Void> save(DataSource dataSource) {
            return CompletableFuture.completedFuture(null);
        }

        public UUID getOwner() {
            return this.owner;
        }

        public List<String> getVaultNames() {
            return this.vaultNames;
        }
    }
}

