/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.utility.BukkitConstants;
import com.dre.brewery.utility.MinecraftVersion;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.block.data.Lightable;
import org.bukkit.material.Cauldron;
import org.bukkit.material.MaterialData;
import org.bukkit.material.Stairs;
import org.jetbrains.annotations.Nullable;

public final class MaterialUtil {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private static final Method GET_BLOCK_TYPE_ID_AT = MaterialUtil.getMethod(World.class, "getBlockTypeIdAt", Location.class);
    private static final Method SET_DATA = MaterialUtil.getMethod(Bukkit.getServer().getClass().getPackage().getName() + ".block.CraftBlock", "setData", Byte.TYPE);
    public static final Material STATIONARY_LAVA = MaterialUtil.getMaterialSafely("STATIONARY_LAVA");
    public static final byte EMPTY = 0;
    public static final byte SOME = 1;
    public static final byte FULL = 2;
    public static final Material WATER_CAULDRON = MaterialUtil.getMaterialSafely("WATER_CAULDRON");
    public static final Material MAGMA_BLOCK = MaterialUtil.getV1_13MaterialSafely("MAGMA_BLOCK", "MAGMA");
    public static final Material CAMPFIRE = MaterialUtil.getMaterialSafely("CAMPFIRE");
    public static final Material SOUL_CAMPFIRE = MaterialUtil.getMaterialSafely("SOUL_CAMPFIRE");
    public static final Material SOUL_FIRE = MaterialUtil.getMaterialSafely("SOUL_FIRE");
    public static final Material CLOCK = MaterialUtil.getV1_13MaterialSafely("CLOCK", "WATCH");

    public static Method getMethod(String clazz, String name, Class<?> ... parameterTypes) {
        try {
            return Class.forName(clazz).getDeclaredMethod(name, parameterTypes);
        }
        catch (ClassNotFoundException | NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            return null;
        }
    }

    @Nullable
    public static Material getMaterialSafely(String name) {
        try {
            for (Material material : BukkitConstants.getMappedValues(Material.class)) {
                if (!material.name().equalsIgnoreCase(name)) continue;
                return material;
            }
            return Material.matchMaterial((String)name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Material getV1_13MaterialSafely(String newName, String oldName) {
        try {
            return Material.valueOf((String)(VERSION.isOrLater(MinecraftVersion.V1_13) ? newName : oldName));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static boolean isCauldronHeatSource(Block block) {
        Material type = block.getType();
        return type == Material.FIRE || type == SOUL_FIRE || type == MAGMA_BLOCK || MaterialUtil.litCampfire(block) || MaterialUtil.isLava(type);
    }

    public static boolean isLava(Material type) {
        return type == Material.LAVA || VERSION.isOrEarlier(MinecraftVersion.V1_13) && type == STATIONARY_LAVA;
    }

    public static boolean litCampfire(Block block) {
        BlockData data;
        if ((block.getType() == CAMPFIRE || block.getType() == SOUL_CAMPFIRE) && (data = block.getBlockData()) instanceof Lightable) {
            return ((Lightable)data).isLit();
        }
        return false;
    }

    public static boolean isBottle(Material type) {
        if (type == Material.POTION) {
            return true;
        }
        if (BreweryPlugin.getMCVersion().isOrEarlier(MinecraftVersion.V1_9)) {
            return false;
        }
        if (type == Material.LINGERING_POTION || type == Material.SPLASH_POTION) {
            return true;
        }
        if (VERSION.isOrEarlier(MinecraftVersion.V1_13)) {
            return false;
        }
        if (type == Material.EXPERIENCE_BOTTLE) {
            return true;
        }
        if (type.name().equals("DRAGON_BREATH")) {
            return true;
        }
        return type.name().equals("HONEY_BOTTLE");
    }

    public static boolean areStairsInverted(Block block) {
        if (VERSION.isOrEarlier(MinecraftVersion.V1_13)) {
            MaterialData data = block.getState().getData();
            return data instanceof Stairs && ((Stairs)data).isInverted();
        }
        BlockData data = block.getBlockData();
        return data instanceof org.bukkit.block.data.type.Stairs && ((org.bukkit.block.data.type.Stairs)data).getHalf() == Bisected.Half.TOP;
    }

    public static boolean isWaterCauldron(Material type) {
        return WATER_CAULDRON != null ? type == WATER_CAULDRON : type == Material.CAULDRON;
    }

    public static byte getFillLevel(Block block) {
        if (!MaterialUtil.isWaterCauldron(block.getType())) {
            return 0;
        }
        if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
            Levelled cauldron = (Levelled)block.getBlockData();
            if (cauldron.getLevel() == 0) {
                return 0;
            }
            if (cauldron.getLevel() == cauldron.getMaximumLevel()) {
                return 2;
            }
            return 1;
        }
        Cauldron cauldron = (Cauldron)PaperLib.getBlockState(block, true).getState().getData();
        if (cauldron.isEmpty()) {
            return 0;
        }
        if (cauldron.isFull()) {
            return 2;
        }
        return 1;
    }

    public static int getBlockTypeIdAt(Location location) {
        try {
            return GET_BLOCK_TYPE_ID_AT != null ? (Integer)GET_BLOCK_TYPE_ID_AT.invoke((Object)location.getWorld(), location) : 0;
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            return 0;
        }
    }

    public static void setData(Block block, byte data) {
        try {
            SET_DATA.invoke((Object)block, data);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {
            // empty catch block
        }
    }
}

