/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.utility;

import com.dre.brewery.commands.subcommands.ReloadCommand;
import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.depend.paperlib.PaperLib;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.MinecraftVersion;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.jetbrains.annotations.Nullable;

public final class Logging {
    private static final Config config = ConfigManager.getConfig(Config.class);

    public static void msg(CommandSender sender, String msg) {
        sender.sendMessage(BUtil.color(config.getPluginPrefix() + msg));
    }

    public static void log(String msg) {
        Bukkit.getConsoleSender().sendMessage(BUtil.color(config.getPluginPrefix() + msg));
    }

    public static void log(LogLevel level, String msg) {
        Logging.log(level, msg, null);
    }

    public static void log(LogLevel level, String msg, @Nullable Throwable throwable) {
        switch (level.ordinal()) {
            case 0: {
                Logging.log(msg);
                break;
            }
            case 1: {
                Logging.warningLog(msg);
                break;
            }
            case 2: {
                if (throwable != null) {
                    Logging.errorLog(msg, throwable);
                    break;
                }
                Logging.errorLog(msg);
                break;
            }
            case 3: {
                Logging.debugLog(msg);
            }
        }
    }

    public static void debugLog(String msg) {
        if (ConfigManager.getConfig(Config.class).isDebug()) {
            Logging.msg((CommandSender)Bukkit.getConsoleSender(), "&2[Debug] &f" + msg);
        }
    }

    public static void warningLog(String msg) {
        Bukkit.getConsoleSender().sendMessage(BUtil.color("&e[BreweryX] WARNING: " + msg));
    }

    public static void errorLog(String msg) {
        String str = BUtil.color("&c[BreweryX] ERROR: " + msg);
        Bukkit.getConsoleSender().sendMessage(str);
        if (ReloadCommand.getReloader() != null) {
            ReloadCommand.getReloader().sendMessage(str);
        }
    }

    public static void errorLog(String msg, Throwable throwable) {
        Logging.errorLog(msg);
        Logging.errorLog("&6" + throwable.toString());
        for (StackTraceElement ste : throwable.getStackTrace()) {
            String str = ste.toString();
            if (str.contains(".jar//")) {
                str = str.substring(str.indexOf(".jar//") + 6);
            }
            Logging.errorLog(str);
        }
        for (Throwable cause = throwable.getCause(); cause != null; cause = cause.getCause()) {
            Bukkit.getConsoleSender().sendMessage(BUtil.color("&c[BreweryX]&6 Caused by: " + String.valueOf(cause)));
            for (StackTraceElement ste : cause.getStackTrace()) {
                String str = ste.toString();
                if (str.contains(".jar//")) {
                    str = str.substring(str.indexOf(".jar//") + 6);
                }
                Bukkit.getConsoleSender().sendMessage(BUtil.color("&c[BreweryX]&6      " + str));
            }
        }
    }

    public static String getEnvironmentAsString() {
        if (MinecraftVersion.isFolia()) {
            return "Folia";
        }
        return PaperLib.getEnvironment().getName();
    }

    public static enum LogLevel {
        INFO,
        WARNING,
        ERROR,
        DEBUG;

    }
}

