/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.storage.impls;

import com.dre.brewery.BCauldron;
import com.dre.brewery.BPlayer;
import com.dre.brewery.Barrel;
import com.dre.brewery.Wakeup;
import com.dre.brewery.configuration.sector.capsule.ConfiguredDataManager;
import com.dre.brewery.storage.DataManager;
import com.dre.brewery.storage.StorageInitException;
import com.dre.brewery.storage.interfaces.SerializableThing;
import com.dre.brewery.storage.records.BreweryMiscData;
import com.dre.brewery.storage.records.SerializableBPlayer;
import com.dre.brewery.storage.records.SerializableBarrel;
import com.dre.brewery.storage.records.SerializableCauldron;
import com.dre.brewery.storage.records.SerializableWakeup;
import com.dre.brewery.storage.serialization.SQLDataSerializer;
import com.dre.brewery.utility.FutureUtil;
import com.dre.brewery.utility.Logging;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.jetbrains.annotations.Nullable;

public class MySQLStorage
extends DataManager {
    private static final String URL = "jdbc:mysql://";
    private static final String[] TABLES = new String[]{"misc (id VARCHAR(4) PRIMARY KEY, data LONGTEXT);", "barrels (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);", "cauldrons (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);", "players (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);", "wakeups (id VARCHAR(36) PRIMARY KEY, data LONGTEXT);"};
    private final Connection connection;
    private final String tablePrefix;
    private final SQLDataSerializer serializer;

    public MySQLStorage(ConfiguredDataManager record) throws StorageInitException {
        super(record.getType());
        try {
            String jdbcUrl = URL + record.getAddress() + "/" + record.getDatabase() + "?autoReconnect=true";
            this.connection = DriverManager.getConnection(jdbcUrl, record.getUsername(), record.getPassword());
            this.tablePrefix = record.getTablePrefix();
            this.serializer = new SQLDataSerializer();
        }
        catch (SQLException e) {
            throw new StorageInitException("Failed to connect to MySQL database! (Did you configure it correctly?)", e);
        }
        try {
            try (String[] statement = this.connection.prepareStatement("USE " + record.getDatabase());){
                statement.execute();
            }
            for (String table : TABLES) {
                try (PreparedStatement statement = this.connection.prepareStatement("CREATE TABLE IF NOT EXISTS " + this.tablePrefix + table);){
                    statement.execute();
                }
            }
        }
        catch (SQLException e) {
            throw new StorageInitException("Failed to create tables!", e);
        }
    }

    @Override
    protected void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to close MySQL connection!", e);
        }
    }

    @Override
    public boolean createTable(String name, int maxIdLength) {
        boolean bl;
        block8: {
            String sql = "CREATE TABLE IF NOT EXISTS " + this.tablePrefix + name + " (id VARCHAR(" + maxIdLength + ") PRIMARY KEY, data LONGTEXT);";
            PreparedStatement statement = this.connection.prepareStatement(sql);
            try {
                statement.execute();
                bl = true;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Logging.errorLog("Failed to create table: " + name + " due to MySQL exception!", e);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    @Override
    public boolean dropTable(String name) {
        boolean bl;
        block8: {
            String sql = "DROP TABLE IF EXISTS " + this.tablePrefix + name;
            PreparedStatement statement = this.connection.prepareStatement(sql);
            try {
                statement.execute();
                bl = true;
                if (statement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    Logging.errorLog("Failed to drop table: " + name + " due to MySQL exception!", e);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T extends SerializableThing> T getGeneric(String id, String table, Class<T> type) {
        String sql = "SELECT data FROM " + this.tablePrefix + table + " WHERE id = ?";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, id.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                SerializableThing serializableThing = (SerializableThing)this.serializer.deserialize(resultSet.getString("data"), type);
                return (T)serializableThing;
            }
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to retrieve object from table: " + table + ", from: MySQL!", e);
        }
        return null;
    }

    @Override
    public <T extends SerializableThing> List<T> getAllGeneric(String table, Class<T> type) {
        String sql = "SELECT id, data FROM " + this.tablePrefix + table;
        ArrayList<SerializableThing> objects = new ArrayList<SerializableThing>();
        try (PreparedStatement statement = this.connection.prepareStatement(sql);
             ResultSet resultSet = statement.executeQuery();){
            while (resultSet.next()) {
                String data = resultSet.getString("data");
                objects.add((SerializableThing)this.serializer.deserialize(data, type));
            }
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to retrieve objects from table: " + table + ", from: MySQL!", e);
        }
        return objects;
    }

    public <T extends SerializableThing> void saveAllGeneric(List<T> serializableThings, String table) {
        this.saveAllGeneric(serializableThings, table, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends SerializableThing> void saveAllGeneric(List<T> serializableThings, String table, @Nullable Class<T> type) {
        String createTempTableSql = "CREATE TEMPORARY TABLE temp_" + table + " (id VARCHAR(36), data LONGTEXT, PRIMARY KEY (id))";
        String insertTempTableSql = "INSERT INTO temp_" + table + " (id, data) VALUES (?, ?) ON DUPLICATE KEY UPDATE data = VALUES(data)";
        String replaceTableSql = "REPLACE INTO " + this.tablePrefix + table + " SELECT * FROM temp_" + table;
        String dropTempTableSql = "DROP TEMPORARY TABLE temp_" + table;
        String deleteOldRecordsSql = "DELETE FROM " + this.tablePrefix + table + " WHERE id NOT IN (SELECT id FROM temp_" + table + ")";
        try {
            this.connection.setAutoCommit(false);
            try (PreparedStatement createTempTableStmt = this.connection.prepareStatement(createTempTableSql);
                 PreparedStatement insertTempTableStmt = this.connection.prepareStatement(insertTempTableSql);){
                createTempTableStmt.execute();
                for (SerializableThing serializableThing : serializableThings) {
                    insertTempTableStmt.setString(1, serializableThing.getId());
                    insertTempTableStmt.setString(2, this.serializer.serialize(serializableThing));
                    insertTempTableStmt.addBatch();
                }
                insertTempTableStmt.executeBatch();
                try (PreparedStatement deleteStmt = this.connection.prepareStatement(deleteOldRecordsSql);){
                    deleteStmt.executeUpdate();
                }
                try (PreparedStatement replaceTableStmt = this.connection.prepareStatement(replaceTableSql);
                     PreparedStatement dropTempTableStmt = this.connection.prepareStatement(dropTempTableSql);){
                    replaceTableStmt.execute();
                    dropTempTableStmt.execute();
                }
                this.connection.commit();
            }
            catch (SQLException e) {
                this.connection.rollback();
                Logging.errorLog("Failed to save objects to: " + table + " due to MySQL exception!", e);
            }
            finally {
                this.connection.setAutoCommit(true);
            }
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to manage transaction for saving objects to: " + table + " due to MySQL exception!", e);
        }
    }

    @Override
    public <T extends SerializableThing> void saveGeneric(T serializableThing, String table) {
        String sql = "INSERT INTO " + this.tablePrefix + table + " (id, data) VALUES (?, ?) ON DUPLICATE KEY UPDATE data = VALUES(data)";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, serializableThing.getId());
            statement.setString(2, this.serializer.serialize(serializableThing));
            statement.execute();
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to save object to:" + table + ", to: MySQL!", e);
        }
    }

    @Override
    public void deleteGeneric(String id, String table) {
        String sql = "DELETE FROM " + this.tablePrefix + table + " WHERE id = ?";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, id);
            statement.execute();
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to delete object from: " + table + ", from: MySQL!", e);
        }
    }

    @Override
    public CompletableFuture<Barrel> getBarrel(UUID id) {
        SerializableBarrel serializableBarrel = this.getGeneric(id.toString(), "barrels", SerializableBarrel.class);
        if (serializableBarrel != null) {
            return serializableBarrel.toBarrel();
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public CompletableFuture<List<Barrel>> getAllBarrels() {
        return FutureUtil.mergeFutures(this.getAllGeneric("barrels", SerializableBarrel.class).stream().map(SerializableBarrel::toBarrel).toList());
    }

    @Override
    public void saveAllBarrels(Collection<Barrel> barrels) {
        List<SerializableBarrel> serializableBarrels = barrels.stream().filter(it -> it.getBounds() != null).map(SerializableBarrel::new).toList();
        this.saveAllGeneric(serializableBarrels, "barrels");
    }

    @Override
    public void saveBarrel(Barrel barrel) {
        this.saveGeneric(new SerializableBarrel(barrel), "barrels");
    }

    @Override
    public void deleteBarrel(UUID id) {
        this.deleteGeneric(id.toString(), "barrels");
    }

    @Override
    public BCauldron getCauldron(UUID id) {
        SerializableCauldron serializableCauldron = this.getGeneric(id.toString(), "cauldrons", SerializableCauldron.class);
        if (serializableCauldron != null) {
            return serializableCauldron.toCauldron();
        }
        return null;
    }

    @Override
    public Collection<BCauldron> getAllCauldrons() {
        return this.getAllGeneric("cauldrons", SerializableCauldron.class).stream().map(SerializableCauldron::toCauldron).toList();
    }

    @Override
    public void saveAllCauldrons(Collection<BCauldron> cauldrons) {
        List<SerializableCauldron> serializableCauldrons = cauldrons.stream().map(SerializableCauldron::new).toList();
        this.saveAllGeneric(serializableCauldrons, "cauldrons");
    }

    @Override
    public void saveCauldron(BCauldron cauldron) {
        this.saveGeneric(new SerializableCauldron(cauldron), "cauldrons");
    }

    @Override
    public void deleteCauldron(UUID id) {
        this.deleteGeneric(id.toString(), "cauldrons");
    }

    @Override
    public BPlayer getPlayer(UUID playerUUID) {
        SerializableBPlayer serializableBPlayer = this.getGeneric(playerUUID.toString(), "players", SerializableBPlayer.class);
        if (serializableBPlayer != null) {
            return serializableBPlayer.toBPlayer();
        }
        return null;
    }

    @Override
    public Collection<BPlayer> getAllPlayers() {
        return this.getAllGeneric("players", SerializableBPlayer.class).stream().map(SerializableBPlayer::toBPlayer).toList();
    }

    @Override
    public void saveAllPlayers(Collection<BPlayer> players) {
        List<SerializableBPlayer> serializableBPlayers = players.stream().map(SerializableBPlayer::new).toList();
        this.saveAllGeneric(serializableBPlayers, "players");
    }

    @Override
    public void savePlayer(BPlayer player) {
        this.saveGeneric(new SerializableBPlayer(player), "players");
    }

    @Override
    public void deletePlayer(UUID playerUUID) {
        this.deleteGeneric(playerUUID.toString(), "players");
    }

    @Override
    public Wakeup getWakeup(UUID id) {
        SerializableWakeup serializableWakeup = this.getGeneric(id.toString(), "wakeups", SerializableWakeup.class);
        if (serializableWakeup != null) {
            return serializableWakeup.toWakeup();
        }
        return null;
    }

    @Override
    public Collection<Wakeup> getAllWakeups() {
        return this.getAllGeneric("wakeups", SerializableWakeup.class).stream().map(SerializableWakeup::toWakeup).toList();
    }

    @Override
    public void saveAllWakeups(Collection<Wakeup> wakeups) {
        List<SerializableWakeup> serializableWakeups = wakeups.stream().map(SerializableWakeup::new).toList();
        this.saveAllGeneric(serializableWakeups, "wakeups");
    }

    @Override
    public void saveWakeup(Wakeup wakeup) {
        this.saveGeneric(new SerializableWakeup(wakeup), "wakeups");
    }

    @Override
    public void deleteWakeup(UUID id) {
        this.deleteGeneric(id.toString(), "wakeups");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public BreweryMiscData getBreweryMiscData() {
        String sql = "SELECT CASE WHEN EXISTS (SELECT 1 FROM " + this.tablePrefix + "misc WHERE id = 'misc') THEN (SELECT data FROM " + this.tablePrefix + "misc WHERE id = 'misc') ELSE NULL END AS data";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);
             ResultSet resultSet = statement.executeQuery();){
            if (!resultSet.next()) return new BreweryMiscData(System.currentTimeMillis(), 0L, new ArrayList<Long>(), new ArrayList<Integer>(), 0);
            if (resultSet.getString("data") == null) return new BreweryMiscData(System.currentTimeMillis(), 0L, new ArrayList<Long>(), new ArrayList<Integer>(), 0);
            BreweryMiscData breweryMiscData = this.serializer.deserialize(resultSet.getString("data"), BreweryMiscData.class);
            return breweryMiscData;
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to retrieve misc data from MySQL!", e);
        }
        return new BreweryMiscData(System.currentTimeMillis(), 0L, new ArrayList<Long>(), new ArrayList<Integer>(), 0);
    }

    @Override
    public void saveBreweryMiscData(BreweryMiscData data) {
        String sql = "INSERT INTO " + this.tablePrefix + "misc (id, data) VALUES ('misc', ?) ON DUPLICATE KEY UPDATE data = VALUES(data)";
        try (PreparedStatement statement = this.connection.prepareStatement(sql);){
            statement.setString(1, this.serializer.serialize(data));
            statement.execute();
        }
        catch (SQLException e) {
            Logging.errorLog("Failed to save misc data to MySQL!", e);
        }
    }
}

