/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BreweryPlugin;
import com.dre.brewery.configuration.sector.capsule.ConfigCustomItem;
import com.dre.brewery.recipe.BCauldronRecipe;
import com.dre.brewery.recipe.CustomItem;
import com.dre.brewery.recipe.CustomMatchAnyItem;
import com.dre.brewery.recipe.DebuggableItem;
import com.dre.brewery.recipe.Ingredient;
import com.dre.brewery.recipe.PluginItem;
import com.dre.brewery.recipe.SimpleItem;
import com.dre.brewery.utility.BUtil;
import com.dre.brewery.utility.Logging;
import com.dre.brewery.utility.MaterialUtil;
import com.dre.brewery.utility.MinecraftVersion;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RecipeItem
implements Cloneable,
DebuggableItem {
    private static final MinecraftVersion VERSION = BreweryPlugin.getMCVersion();
    private String cfgId;
    private int amount;
    private boolean immutable = false;

    public abstract boolean matches(ItemStack var1);

    public abstract boolean matches(Ingredient var1);

    @NotNull
    public abstract Ingredient toIngredient(ItemStack var1);

    @NotNull
    public abstract Ingredient toIngredientGeneric();

    public abstract boolean hasMaterials();

    @Nullable
    public abstract List<Material> getMaterials();

    public String getConfigId() {
        return this.cfgId;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        if (this.immutable) {
            throw new IllegalStateException("Setting amount only possible on mutable copy");
        }
        this.amount = amount;
    }

    public void makeImmutable() {
        this.immutable = true;
    }

    public RecipeItem getMutableCopy() {
        try {
            RecipeItem i = (RecipeItem)super.clone();
            i.immutable = false;
            return i;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e);
        }
    }

    @Nullable
    @Contract(value="_, true -> !null")
    public static RecipeItem getMatchingRecipeItem(ItemStack item, boolean acceptAll) {
        RecipeItem rItem = null;
        boolean multiMatch = false;
        for (RecipeItem ri : BCauldronRecipe.acceptedCustom) {
            if (multiMatch && !(ri instanceof PluginItem) || !ri.matches(item)) continue;
            if (ri instanceof PluginItem) {
                return ri;
            }
            if (rItem == null) {
                rItem = ri;
                continue;
            }
            multiMatch = true;
        }
        if (multiMatch) {
            return new CustomItem(item);
        }
        if (rItem == null && (acceptAll || BCauldronRecipe.acceptedSimple.contains(item.getType()))) {
            if (VERSION.isOrLater(MinecraftVersion.V1_13)) {
                return new SimpleItem(item.getType());
            }
            short durability = item.getDurability();
            return new SimpleItem(item.getType(), durability);
        }
        return rItem;
    }

    @Nullable
    public static RecipeItem fromConfigCustom(String id, ConfigCustomItem configCustomItem) {
        RecipeItem rItem = configCustomItem.getMatchAny() != null && configCustomItem.getMatchAny() != false ? new CustomMatchAnyItem() : new CustomItem();
        rItem.cfgId = id;
        rItem.immutable = true;
        List<Material> materials = BUtil.getListSafely(configCustomItem.getMaterial(), Material.class);
        List<String> names = BUtil.colorArrayList(BUtil.getListSafely(configCustomItem.getName()));
        List<String> lore = BUtil.colorArrayList(BUtil.getListSafely(configCustomItem.getLore()));
        List<Integer> customModelDatas = BUtil.getListSafely(configCustomItem.getCustomModelData());
        if (!(materials != null && !materials.isEmpty() || names != null && !names.isEmpty() || lore != null && !lore.isEmpty() || customModelDatas != null && !customModelDatas.isEmpty())) {
            return null;
        }
        if (rItem instanceof CustomItem) {
            RecipeItem cItem = rItem;
            if (!materials.isEmpty()) {
                ((CustomItem)cItem).setMat(materials.get(0));
            }
            if (!names.isEmpty()) {
                ((CustomItem)cItem).setName(names.get(0));
            }
            ((CustomItem)cItem).setLore(lore);
            if (!customModelDatas.isEmpty()) {
                ((CustomItem)cItem).setCustomModelData(customModelDatas.get(0));
            }
        } else {
            CustomMatchAnyItem maItem = (CustomMatchAnyItem)rItem;
            maItem.setMaterials(materials);
            maItem.setNames(names);
            maItem.setLore(lore);
            maItem.setCustomModelDatas(customModelDatas);
        }
        return rItem;
    }

    @Nullable
    protected static List<Material> loadMaterials(List<String> ingredientsList) {
        ArrayList<Material> materials = new ArrayList<Material>(ingredientsList.size());
        for (String item : ingredientsList) {
            String[] ingredParts = item.split("/");
            if (ingredParts.length == 2) {
                Logging.errorLog("Item Amount can not be specified for Custom Items: " + item);
                return null;
            }
            Material mat = MaterialUtil.getMaterialSafely(ingredParts[0]);
            if (mat == null && VERSION.isOrEarlier(MinecraftVersion.V1_14) && ingredParts[0].equalsIgnoreCase("cornflower")) {
                materials.add(Material.BEDROCK);
                continue;
            }
            if (mat != null) {
                materials.add(mat);
                continue;
            }
            Logging.errorLog("Unknown Material: " + ingredParts[0]);
            return null;
        }
        return materials;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RecipeItem)) {
            return false;
        }
        RecipeItem that = (RecipeItem)o;
        return this.amount == that.amount && this.immutable == that.immutable && Objects.equals(this.cfgId, that.cfgId);
    }

    public int hashCode() {
        return Objects.hash(this.cfgId, this.amount, this.immutable);
    }

    public String toString() {
        return "RecipeItem{(" + this.getClass().getSimpleName() + ") ID: " + this.getConfigId() + " Materials: " + (this.hasMaterials() ? this.getMaterials().size() : 0) + " Amount: " + this.getAmount();
    }

    @Override
    public String debug() {
        if (this.getAmount() == 1) {
            return this.getDebugID();
        }
        return this.getDebugID() + "/" + this.getAmount();
    }

    public String toConfigString() {
        return this.toConfigStringNoAmount() + "/" + this.getAmount();
    }

    public String toConfigStringNoAmount() {
        RecipeItem recipeItem = this;
        if (recipeItem instanceof SimpleItem) {
            SimpleItem simpleItem = (SimpleItem)recipeItem;
            return simpleItem.getMaterial().toString().toLowerCase();
        }
        recipeItem = this;
        if (recipeItem instanceof PluginItem) {
            PluginItem pluginItem = (PluginItem)recipeItem;
            return pluginItem.getPlugin() + ":" + pluginItem.getItemId();
        }
        if (this instanceof CustomItem || this instanceof CustomMatchAnyItem) {
            return this.getConfigId();
        }
        throw new IllegalStateException("Unknown RecipeItem Type!");
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

