/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BrewDefect;

public class QualityDeduction
implements Comparable<QualityDeduction> {
    private final BrewDefect defect;
    private final float qualityDeduction;

    public static QualityDeduction deduction(BrewDefect defect, float qualityDeduction) {
        if (!Float.isFinite(qualityDeduction)) {
            throw new IllegalArgumentException("qualityDeduction must be finite");
        }
        return new QualityDeduction(defect, qualityDeduction);
    }

    public static QualityDeduction fatal(BrewDefect defect) {
        return new QualityDeduction(defect, Float.NEGATIVE_INFINITY);
    }

    public boolean isFatal() {
        return this.qualityDeduction == Float.NEGATIVE_INFINITY;
    }

    public QualityDeduction scale(float f) {
        if (f < 0.0f) {
            throw new IllegalArgumentException("f must be positive");
        }
        return new QualityDeduction(this.defect, this.qualityDeduction * f);
    }

    @Override
    public int compareTo(QualityDeduction other) {
        return Float.compare(this.qualityDeduction, other.qualityDeduction);
    }

    public String toString() {
        if (this.isFatal()) {
            return "FATAL " + String.valueOf(this.defect);
        }
        return String.format("-%.3f %s", Float.valueOf(this.qualityDeduction), this.defect);
    }

    private QualityDeduction(BrewDefect defect, float qualityDeduction) {
        this.defect = defect;
        this.qualityDeduction = qualityDeduction;
    }

    public BrewDefect getDefect() {
        return this.defect;
    }

    public float getQualityDeduction() {
        return this.qualityDeduction;
    }
}

