/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.recipe;

import com.dre.brewery.BrewDefect;
import com.dre.brewery.recipe.BRecipe;
import com.dre.brewery.recipe.RecipeEvaluation;
import com.dre.brewery.utility.BUtil;
import java.util.StringJoiner;
import org.jetbrains.annotations.Nullable;

public sealed interface BestRecipeResult {
    @Nullable
    public BRecipe getSuccessRecipe();

    @Nullable
    public BrewDefect getWorstDefect();

    public record NoRecipesRegistered() implements BestRecipeResult
    {
        @Override
        @Nullable
        public BRecipe getSuccessRecipe() {
            return null;
        }

        @Override
        public BrewDefect getWorstDefect() {
            return new BrewDefect.NoRecipesRegistered();
        }

        @Override
        public String toString() {
            return "NoRecipesRegistered{}";
        }
    }

    public record Error(BRecipe guess, RecipeEvaluation eval) implements BestRecipeResult
    {
        @Override
        @Nullable
        public BRecipe getSuccessRecipe() {
            return null;
        }

        @Override
        @Nullable
        public BrewDefect getWorstDefect() {
            return BUtil.choose(this.eval.getWorstDefects());
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", "Error{", "}").add("guess=" + String.valueOf(this.guess)).add("eval=" + String.valueOf(this.eval)).toString();
        }
    }

    public record Found(BRecipe recipe, RecipeEvaluation eval) implements BestRecipeResult
    {
        @Override
        @Nullable
        public BRecipe getSuccessRecipe() {
            return this.recipe;
        }

        @Override
        @Nullable
        public BrewDefect getWorstDefect() {
            return null;
        }

        @Override
        public String toString() {
            return new StringJoiner(", ", "Found{", "}").add("recipe=" + String.valueOf(this.recipe)).add("eval=" + String.valueOf(this.eval)).toString();
        }
    }
}

