/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration.listeners.movecraft;

import com.dre.brewery.Barrel;
import com.dre.brewery.BarrelWoodType;
import com.dre.brewery.integration.listeners.movecraft.MovecraftUtil;
import com.dre.brewery.integration.listeners.movecraft.properties.BreweryProperties;
import com.dre.brewery.integration.listeners.movecraft.properties.MaxBarrelEntry;
import java.util.EnumMap;
import java.util.Set;
import net.countercraft.movecraft.craft.Craft;
import net.countercraft.movecraft.craft.type.CraftType;
import net.countercraft.movecraft.events.CraftDetectEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;

public class CraftDetectListener
implements Listener {
    @EventHandler
    public void onCraftDetect(CraftDetectEvent event) {
        Craft craft = event.getCraft();
        CraftType type = craft.getType();
        boolean allAllowed = type.getBoolProperty(BreweryProperties.ALL_BARRELS_ALLOWED);
        if (allAllowed) {
            return;
        }
        Set<Barrel> barrels = MovecraftUtil.barrelsOnCraft(craft.getHitBox(), craft.getWorld());
        Set<MaxBarrelEntry> maxBarrels = MovecraftUtil.getBarrelsProperty(type);
        if (maxBarrels.isEmpty() && !barrels.isEmpty()) {
            event.setCancelled(true);
            event.setFailMessage("Detection Failed! Barrels aren't allowed on this craft!");
            return;
        }
        EnumMap<BarrelWoodType, Integer> barrelCount = new EnumMap<BarrelWoodType, Integer>(BarrelWoodType.class);
        for (Barrel barrel : barrels) {
            BarrelWoodType woodType = barrel.getWood();
            barrelCount.compute(woodType, (key, value) -> value == null ? 1 : value + 1);
        }
        int size = craft.getOrigBlockCount();
        for (MaxBarrelEntry entry : maxBarrels) {
            String result;
            if (!(entry instanceof MaxBarrelEntry)) {
                throw new IllegalStateException("maxBarrels must be a set of MaxBarrelEntry.");
            }
            MaxBarrelEntry max = entry;
            BarrelWoodType barrelType = max.type();
            Integer count = (Integer)barrelCount.get((Object)barrelType);
            if (count == null || (result = max.detect(count, size)) == null) continue;
            event.setCancelled(true);
            event.setFailMessage("Detection Failed! You have too many barrels of the following type on this craft: " + String.valueOf((Object)barrelType) + ": " + result);
        }
    }
}

