/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.integration;

import com.dre.brewery.configuration.ConfigManager;
import com.dre.brewery.configuration.files.Config;
import com.dre.brewery.utility.Logging;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;

public class Hook {
    protected static final Config config = ConfigManager.getConfig(Config.class);
    public static final Hook LWC = new Hook("LWC", config.isUseLWC());
    public static final Hook GRIEFPREVENTION = new Hook("GriefPrevention", config.isUseGriefPrevention());
    public static final Hook TOWNY = new Hook("Towny", config.isUseTowny());
    public static final Hook LANDS = new Hook("Lands", config.isUseLands());
    public static final Hook LOGBLOCK = new Hook("LogBlock", config.isUseLogBlock());
    public static final Hook GAMEMODEINVENTORIES = new Hook("GameModeInventories", config.isUseGMInventories());
    public static final Hook MMOITEMS = new Hook("MMOItems");
    public static final Hook CHESTSHOP = new Hook("ChestShop");
    public static final Hook SHOPKEEPERS = new Hook("ShopKeepers");
    public static final Hook SLIMEFUN = new Hook("Slimefun");
    public static final Hook ORAXEN = new Hook("Oraxen");
    public static final Hook ITEMSADDER = new Hook("ItemsAdder");
    public static final Hook NEXO = new Hook("Nexo");
    public static final Hook MOVECRAFT = new Hook("Movecraft");
    private final String name;
    @ApiStatus.Internal
    private boolean enabled;
    private boolean checked;

    public Hook(String name) {
        this.name = name;
        this.enabled = true;
    }

    public Hook(String name, boolean enabled) {
        this.name = name;
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        if (!this.checked) {
            this.checked = true;
            if (this.enabled) {
                this.enabled = Bukkit.getPluginManager().isPluginEnabled(this.name);
            }
        }
        return this.enabled;
    }

    @Contract
    public Plugin getPlugin() {
        if (this.isEnabled()) {
            Plugin plugin = Bukkit.getPluginManager().getPlugin(this.name);
            if (plugin == null) {
                Logging.errorLog("Plugin " + this.name + " is marked enabled but not found!");
            }
            return plugin;
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isChecked() {
        return this.checked;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setChecked(boolean checked) {
        this.checked = checked;
    }
}

