/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.selector;

import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterConnectionMode;
import com.dre.brewery.depend.mongodb.connection.ClusterDescription;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.internal.connection.ClusterDescriptionHelper;
import com.dre.brewery.depend.mongodb.selector.ServerSelector;
import java.util.List;

public class ReadPreferenceServerSelector
implements ServerSelector {
    private final ReadPreference readPreference;

    public ReadPreferenceServerSelector(ReadPreference readPreference) {
        this.readPreference = Assertions.notNull("readPreference", readPreference);
    }

    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
            return ClusterDescriptionHelper.getAny(clusterDescription);
        }
        return this.readPreference.choose(clusterDescription);
    }

    public String toString() {
        return "ReadPreferenceServerSelector{readPreference=" + this.readPreference + '}';
    }
}

