/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.selector;

import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.connection.ClusterDescription;
import com.dre.brewery.depend.mongodb.connection.ServerDescription;
import com.dre.brewery.depend.mongodb.internal.connection.Cluster;
import com.dre.brewery.depend.mongodb.selector.ServerSelector;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@ThreadSafe
public final class MinimumOperationCountServerSelector
implements ServerSelector {
    private final Cluster.ServersSnapshot serversSnapshot;

    public MinimumOperationCountServerSelector(Cluster.ServersSnapshot serversSnapshot) {
        this.serversSnapshot = serversSnapshot;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        return clusterDescription.getServerDescriptions().stream().min(Comparator.comparingInt(serverDescription -> Assertions.assertNotNull(this.serversSnapshot.getServer(serverDescription.getAddress())).operationCount())).map(Collections::singletonList).orElse(Collections.emptyList());
    }
}

