/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.internal.async.AsyncBatchCursor;
import com.dre.brewery.depend.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncReadBinding;
import com.dre.brewery.depend.mongodb.internal.binding.ReadBinding;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.BatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.CommandOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultDocumentCodec;
import com.dre.brewery.depend.mongodb.internal.operation.DocumentHelper;
import com.dre.brewery.depend.mongodb.internal.operation.OperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.ReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperationHelper;
import com.dre.brewery.depend.mongodb.lang.Nullable;

public class ListDatabasesOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String DATABASES = "databases";
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private Boolean nameOnly;
    private Boolean authorizedDatabasesOnly;
    private BsonValue comment;

    public ListDatabasesOperation(Decoder<T> decoder) {
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public ListDatabasesOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public ListDatabasesOperation<T> nameOnly(Boolean nameOnly) {
        this.nameOnly = nameOnly;
        return this;
    }

    public ListDatabasesOperation<T> authorizedDatabasesOnly(Boolean authorizedDatabasesOnly) {
        this.authorizedDatabasesOnly = authorizedDatabasesOnly;
        return this;
    }

    public ListDatabasesOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Boolean getNameOnly() {
        return this.nameOnly;
    }

    public Boolean getAuthorizedDatabasesOnly() {
        return this.authorizedDatabasesOnly;
    }

    @Nullable
    public BsonValue getComment() {
        return this.comment;
    }

    public ListDatabasesOperation<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, DATABASES), SyncOperationHelper.singleBatchCursorTransformer(DATABASES), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, "admin", this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, DATABASES), AsyncOperationHelper.asyncSingleBatchCursorTransformer(DATABASES), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument commandDocument = new BsonDocument("listDatabases", new BsonInt32(1));
            DocumentHelper.putIfNotNull(commandDocument, "filter", this.filter);
            DocumentHelper.putIfNotNull(commandDocument, "nameOnly", this.nameOnly);
            DocumentHelper.putIfNotNull(commandDocument, "authorizedDatabases", this.authorizedDatabasesOnly);
            DocumentHelper.putIfNotNull(commandDocument, "comment", this.comment);
            return commandDocument;
        };
    }
}

