/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.FieldNameValidator;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.Collation;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.internal.operation.BaseFindAndModifyOperation;
import com.dre.brewery.depend.mongodb.internal.operation.DocumentHelper;
import com.dre.brewery.depend.mongodb.internal.validator.MappedFieldNameValidator;
import com.dre.brewery.depend.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dre.brewery.depend.mongodb.internal.validator.ReplacingDocumentFieldNameValidator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Collections;

public class FindAndReplaceOperation<T>
extends BaseFindAndModifyOperation<T> {
    private final BsonDocument replacement;
    private boolean returnOriginal = true;
    private boolean upsert;
    private Boolean bypassDocumentValidation;

    public FindAndReplaceOperation(MongoNamespace namespace, WriteConcern writeConcern, boolean retryWrites, Decoder<T> decoder, BsonDocument replacement) {
        super(namespace, writeConcern, retryWrites, decoder);
        this.replacement = Assertions.notNull("replacement", replacement);
    }

    public BsonDocument getReplacement() {
        return this.replacement;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndReplaceOperation<T> returnOriginal(boolean returnOriginal) {
        this.returnOriginal = returnOriginal;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndReplaceOperation<T> upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public FindAndReplaceOperation<T> bypassDocumentValidation(@Nullable Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> filter(@Nullable BsonDocument filter) {
        super.filter(filter);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> projection(@Nullable BsonDocument projection) {
        super.projection(projection);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> sort(@Nullable BsonDocument sort) {
        super.sort(sort);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> hint(@Nullable BsonDocument hint) {
        super.hint(hint);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> hintString(@Nullable String hint) {
        super.hintString(hint);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> collation(@Nullable Collation collation) {
        super.collation(collation);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> comment(@Nullable BsonValue comment) {
        super.comment(comment);
        return this;
    }

    @Override
    public FindAndReplaceOperation<T> let(@Nullable BsonDocument variables) {
        super.let(variables);
        return this;
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        return new MappedFieldNameValidator(NoOpFieldNameValidator.INSTANCE, Collections.singletonMap("update", ReplacingDocumentFieldNameValidator.INSTANCE));
    }

    @Override
    protected void specializeCommand(BsonDocument commandDocument, ConnectionDescription connectionDescription) {
        commandDocument.put("new", new BsonBoolean(!this.isReturnOriginal()));
        DocumentHelper.putIfTrue(commandDocument, "upsert", this.isUpsert());
        commandDocument.put("update", this.getReplacement());
        if (this.bypassDocumentValidation != null) {
            commandDocument.put("bypassDocumentValidation", BsonBoolean.valueOf(this.bypassDocumentValidation));
        }
    }
}

