/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.mongodb.ExplainVerbosity;
import com.dre.brewery.depend.mongodb.MongoInternalException;
import com.dre.brewery.depend.mongodb.lang.Nullable;

final class ExplainHelper {
    static BsonDocument asExplainCommand(BsonDocument command, @Nullable ExplainVerbosity explainVerbosity) {
        BsonDocument explainCommand = new BsonDocument("explain", command);
        if (explainVerbosity != null) {
            explainCommand.append("verbosity", ExplainHelper.getVerbosityAsString(explainVerbosity));
        }
        return explainCommand;
    }

    private static BsonString getVerbosityAsString(ExplainVerbosity explainVerbosity) {
        switch (explainVerbosity) {
            case QUERY_PLANNER: {
                return new BsonString("queryPlanner");
            }
            case EXECUTION_STATS: {
                return new BsonString("executionStats");
            }
            case ALL_PLANS_EXECUTIONS: {
                return new BsonString("allPlansExecution");
            }
        }
        throw new MongoInternalException(String.format("Unsupported explain verbosity %s", new Object[]{explainVerbosity}));
    }

    private ExplainHelper() {
    }
}

