/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.Collation;
import com.dre.brewery.depend.mongodb.internal.async.AsyncBatchCursor;
import com.dre.brewery.depend.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncReadBinding;
import com.dre.brewery.depend.mongodb.internal.binding.ReadBinding;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.BatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.CommandOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultDocumentCodec;
import com.dre.brewery.depend.mongodb.internal.operation.DocumentHelper;
import com.dre.brewery.depend.mongodb.internal.operation.OperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.OperationReadConcernHelper;
import com.dre.brewery.depend.mongodb.internal.operation.ReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperationHelper;
import com.dre.brewery.depend.mongodb.lang.Nullable;

public class DistinctOperation<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String VALUES = "values";
    private final MongoNamespace namespace;
    private final String fieldName;
    private final Decoder<T> decoder;
    private boolean retryReads;
    private BsonDocument filter;
    private Collation collation;
    private BsonValue comment;

    public DistinctOperation(MongoNamespace namespace, String fieldName, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.fieldName = Assertions.notNull("fieldName", fieldName);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public DistinctOperation<T> filter(@Nullable BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public DistinctOperation<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    public boolean getRetryReads() {
        return this.retryReads;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public DistinctOperation<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    public BsonValue getComment() {
        return this.comment;
    }

    public DistinctOperation<T> comment(BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), SyncOperationHelper.singleBatchCursorTransformer(VALUES), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), this.createCommandDecoder(), AsyncOperationHelper.asyncSingleBatchCursorTransformer(VALUES), this.retryReads, ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER));
    }

    private Codec<BsonDocument> createCommandDecoder() {
        return CommandResultDocumentCodec.create(this.decoder, VALUES);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument commandDocument = new BsonDocument("distinct", new BsonString(this.namespace.getCollectionName()));
            OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), connectionDescription.getMaxWireVersion(), commandDocument);
            commandDocument.put("key", new BsonString(this.fieldName));
            DocumentHelper.putIfNotNull(commandDocument, "query", this.filter);
            if (this.collation != null) {
                commandDocument.put("collation", this.collation.asDocument());
            }
            DocumentHelper.putIfNotNull(commandDocument, "comment", this.comment);
            return commandDocument;
        };
    }
}

