/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.model.SearchIndexType;
import com.dre.brewery.depend.mongodb.internal.operation.AbstractWriteSearchIndexOperation;
import com.dre.brewery.depend.mongodb.internal.operation.SearchIndexRequest;
import java.util.List;
import java.util.stream.Collectors;

public final class CreateSearchIndexesOperation
extends AbstractWriteSearchIndexOperation {
    private static final String COMMAND_NAME = "createSearchIndexes";
    private final List<SearchIndexRequest> indexRequests;

    public CreateSearchIndexesOperation(MongoNamespace namespace, List<SearchIndexRequest> indexRequests) {
        super(namespace);
        this.indexRequests = Assertions.assertNotNull(indexRequests);
    }

    private static BsonArray convert(List<SearchIndexRequest> requests) {
        return requests.stream().map(CreateSearchIndexesOperation::convert).collect(Collectors.toCollection(BsonArray::new));
    }

    private static BsonDocument convert(SearchIndexRequest request) {
        SearchIndexType searchIndexType;
        BsonDocument bsonIndexRequest = new BsonDocument();
        String searchIndexName = request.getIndexName();
        if (searchIndexName != null) {
            bsonIndexRequest.append("name", new BsonString(searchIndexName));
        }
        if ((searchIndexType = request.getSearchIndexType()) != null) {
            bsonIndexRequest.append("type", searchIndexType.toBsonValue());
        }
        bsonIndexRequest.append("definition", request.getDefinition());
        return bsonIndexRequest;
    }

    @Override
    BsonDocument buildCommand() {
        return new BsonDocument(COMMAND_NAME, new BsonString(this.getNamespace().getCollectionName())).append("indexes", CreateSearchIndexesOperation.convert(this.indexRequests));
    }
}

