/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonDouble;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonInt64;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.mongodb.CreateIndexCommitQuorum;
import com.dre.brewery.depend.mongodb.DuplicateKeyException;
import com.dre.brewery.depend.mongodb.ErrorCategory;
import com.dre.brewery.depend.mongodb.MongoClientException;
import com.dre.brewery.depend.mongodb.MongoCommandException;
import com.dre.brewery.depend.mongodb.MongoException;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.WriteConcern;
import com.dre.brewery.depend.mongodb.WriteConcernResult;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncWriteBinding;
import com.dre.brewery.depend.mongodb.internal.binding.WriteBinding;
import com.dre.brewery.depend.mongodb.internal.bulk.IndexRequest;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncWriteOperation;
import com.dre.brewery.depend.mongodb.internal.operation.CommandOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.IndexHelper;
import com.dre.brewery.depend.mongodb.internal.operation.ServerVersionHelper;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.WriteConcernHelper;
import com.dre.brewery.depend.mongodb.internal.operation.WriteOperation;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CreateIndexesOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final List<IndexRequest> requests;
    private final WriteConcern writeConcern;
    private CreateIndexCommitQuorum commitQuorum;

    public CreateIndexesOperation(MongoNamespace namespace, List<IndexRequest> requests, @Nullable WriteConcern writeConcern) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.requests = Assertions.notNull("indexRequests", requests);
        this.writeConcern = writeConcern;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public List<IndexRequest> getRequests() {
        return this.requests;
    }

    public List<String> getIndexNames() {
        ArrayList<String> indexNames = new ArrayList<String>(this.requests.size());
        for (IndexRequest request : this.requests) {
            if (request.getName() != null) {
                indexNames.add(request.getName());
                continue;
            }
            indexNames.add(IndexHelper.generateIndexName(request.getKeys()));
        }
        return indexNames;
    }

    public CreateIndexCommitQuorum getCommitQuorum() {
        return this.commitQuorum;
    }

    public CreateIndexesOperation commitQuorum(@Nullable CreateIndexCommitQuorum commitQuorum) {
        this.commitQuorum = commitQuorum;
        return this;
    }

    @Override
    public Void execute(WriteBinding binding) {
        try {
            return SyncOperationHelper.executeCommand(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), SyncOperationHelper.writeConcernErrorTransformer(binding.getOperationContext().getTimeoutContext()));
        }
        catch (MongoCommandException e) {
            throw this.checkForDuplicateKeyError(e);
        }
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        AsyncOperationHelper.executeCommandAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), AsyncOperationHelper.writeConcernErrorTransformerAsync(binding.getOperationContext().getTimeoutContext()), (result, t) -> {
            if (t != null) {
                callback.onResult(null, this.translateException(t));
            } else {
                callback.onResult((Void)result, null);
            }
        });
    }

    private BsonDocument getIndex(IndexRequest request) {
        BsonDocument index = new BsonDocument();
        index.append("key", request.getKeys());
        index.append("name", new BsonString(request.getName() != null ? request.getName() : IndexHelper.generateIndexName(request.getKeys())));
        if (request.isBackground()) {
            index.append("background", BsonBoolean.TRUE);
        }
        if (request.isUnique()) {
            index.append("unique", BsonBoolean.TRUE);
        }
        if (request.isSparse()) {
            index.append("sparse", BsonBoolean.TRUE);
        }
        if (request.getExpireAfter(TimeUnit.SECONDS) != null) {
            index.append("expireAfterSeconds", new BsonInt64(Assertions.assertNotNull(request.getExpireAfter(TimeUnit.SECONDS))));
        }
        if (request.getVersion() != null) {
            index.append("v", new BsonInt32(Assertions.assertNotNull(request.getVersion())));
        }
        if (request.getWeights() != null) {
            index.append("weights", Assertions.assertNotNull(request.getWeights()));
        }
        if (request.getDefaultLanguage() != null) {
            index.append("default_language", new BsonString(Assertions.assertNotNull(request.getDefaultLanguage())));
        }
        if (request.getLanguageOverride() != null) {
            index.append("language_override", new BsonString(Assertions.assertNotNull(request.getLanguageOverride())));
        }
        if (request.getTextVersion() != null) {
            index.append("textIndexVersion", new BsonInt32(Assertions.assertNotNull(request.getTextVersion())));
        }
        if (request.getSphereVersion() != null) {
            index.append("2dsphereIndexVersion", new BsonInt32(Assertions.assertNotNull(request.getSphereVersion())));
        }
        if (request.getBits() != null) {
            index.append("bits", new BsonInt32(Assertions.assertNotNull(request.getBits())));
        }
        if (request.getMin() != null) {
            index.append("min", new BsonDouble(Assertions.assertNotNull(request.getMin())));
        }
        if (request.getMax() != null) {
            index.append("max", new BsonDouble(Assertions.assertNotNull(request.getMax())));
        }
        if (request.getDropDups()) {
            index.append("dropDups", BsonBoolean.TRUE);
        }
        if (request.getStorageEngine() != null) {
            index.append("storageEngine", Assertions.assertNotNull(request.getStorageEngine()));
        }
        if (request.getPartialFilterExpression() != null) {
            index.append("partialFilterExpression", Assertions.assertNotNull(request.getPartialFilterExpression()));
        }
        if (request.getCollation() != null) {
            index.append("collation", Assertions.assertNotNull(request.getCollation().asDocument()));
        }
        if (request.getWildcardProjection() != null) {
            index.append("wildcardProjection", Assertions.assertNotNull(request.getWildcardProjection()));
        }
        if (request.isHidden()) {
            index.append("hidden", BsonBoolean.TRUE);
        }
        return index;
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> {
            BsonDocument command = new BsonDocument("createIndexes", new BsonString(this.namespace.getCollectionName()));
            ArrayList<BsonDocument> values = new ArrayList<BsonDocument>();
            for (IndexRequest request : this.requests) {
                values.add(this.getIndex(request));
            }
            command.put("indexes", new BsonArray(values));
            WriteConcernHelper.appendWriteConcernToCommand(this.writeConcern, command);
            if (this.commitQuorum != null) {
                if (ServerVersionHelper.serverIsAtLeastVersionFourDotFour(connectionDescription)) {
                    command.put("commitQuorum", this.commitQuorum.toBsonValue());
                } else {
                    throw new MongoClientException("Specifying a value for the create index commit quorum option requires a minimum MongoDB version of 4.4");
                }
            }
            return command;
        };
    }

    @Nullable
    private MongoException translateException(@Nullable Throwable t) {
        return t instanceof MongoCommandException ? this.checkForDuplicateKeyError((MongoCommandException)t) : MongoException.fromThrowable(t);
    }

    private MongoException checkForDuplicateKeyError(MongoCommandException e) {
        if (ErrorCategory.fromErrorCode(e.getCode()) == ErrorCategory.DUPLICATE_KEY) {
            return new DuplicateKeyException(e.getResponse(), e.getServerAddress(), WriteConcernResult.acknowledged(0, false, null));
        }
        return e;
    }
}

