/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.BsonArrayCodec;
import com.dre.brewery.depend.bson.codecs.BsonBinaryCodec;
import com.dre.brewery.depend.bson.codecs.BsonBooleanCodec;
import com.dre.brewery.depend.bson.codecs.BsonDBPointerCodec;
import com.dre.brewery.depend.bson.codecs.BsonDateTimeCodec;
import com.dre.brewery.depend.bson.codecs.BsonDecimal128Codec;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.BsonDoubleCodec;
import com.dre.brewery.depend.bson.codecs.BsonInt32Codec;
import com.dre.brewery.depend.bson.codecs.BsonInt64Codec;
import com.dre.brewery.depend.bson.codecs.BsonJavaScriptCodec;
import com.dre.brewery.depend.bson.codecs.BsonJavaScriptWithScopeCodec;
import com.dre.brewery.depend.bson.codecs.BsonMaxKeyCodec;
import com.dre.brewery.depend.bson.codecs.BsonMinKeyCodec;
import com.dre.brewery.depend.bson.codecs.BsonNullCodec;
import com.dre.brewery.depend.bson.codecs.BsonObjectIdCodec;
import com.dre.brewery.depend.bson.codecs.BsonRegularExpressionCodec;
import com.dre.brewery.depend.bson.codecs.BsonStringCodec;
import com.dre.brewery.depend.bson.codecs.BsonSymbolCodec;
import com.dre.brewery.depend.bson.codecs.BsonTimestampCodec;
import com.dre.brewery.depend.bson.codecs.BsonUndefinedCodec;
import com.dre.brewery.depend.bson.codecs.Codec;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.bson.codecs.configuration.CodecProvider;
import com.dre.brewery.depend.bson.codecs.configuration.CodecRegistry;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultDocumentCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class CommandResultCodecProvider<P>
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Decoder<P> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultCodecProvider(Decoder<P> payloadDecoder, List<String> fieldContainingPayload) {
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldContainingPayload;
        this.addCodecs();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonDocument.class) {
            return new CommandResultDocumentCodec<P>(registry, this.payloadDecoder, this.fieldsContainingPayload);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
        this.addCodec(new BsonJavaScriptWithScopeCodec(new BsonDocumentCodec()));
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResultCodecProvider that = (CommandResultCodecProvider)o;
        if (!this.fieldsContainingPayload.equals(that.fieldsContainingPayload)) {
            return false;
        }
        return this.payloadDecoder.getClass().equals(that.payloadDecoder.getClass());
    }

    public int hashCode() {
        int result = this.payloadDecoder.getClass().hashCode();
        result = 31 * result + this.fieldsContainingPayload.hashCode();
        return result;
    }
}

