/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonTimestamp;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.BsonDocumentCodec;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.MongoCommandException;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.MongoOperationTimeoutException;
import com.dre.brewery.depend.mongodb.MongoSocketException;
import com.dre.brewery.depend.mongodb.ReadPreference;
import com.dre.brewery.depend.mongodb.ServerAddress;
import com.dre.brewery.depend.mongodb.ServerCursor;
import com.dre.brewery.depend.mongodb.annotations.ThreadSafe;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.cursor.TimeoutMode;
import com.dre.brewery.depend.mongodb.connection.ConnectionDescription;
import com.dre.brewery.depend.mongodb.connection.ServerType;
import com.dre.brewery.depend.mongodb.internal.TimeoutContext;
import com.dre.brewery.depend.mongodb.internal.async.AsyncAggregateResponseBatchCursor;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.function.AsyncCallbackSupplier;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncConnectionSource;
import com.dre.brewery.depend.mongodb.internal.connection.AsyncConnection;
import com.dre.brewery.depend.mongodb.internal.connection.Connection;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.CommandBatchCursorHelper;
import com.dre.brewery.depend.mongodb.internal.operation.CommandCursorResult;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultDocumentCodec;
import com.dre.brewery.depend.mongodb.internal.operation.CursorResourceManager;
import com.dre.brewery.depend.mongodb.internal.validator.NoOpFieldNameValidator;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class AsyncCommandBatchCursor<T>
implements AsyncAggregateResponseBatchCursor<T> {
    private final MongoNamespace namespace;
    private final long maxTimeMS;
    private final Decoder<T> decoder;
    @Nullable
    private final BsonValue comment;
    private final int maxWireVersion;
    private final boolean firstBatchEmpty;
    private final ResourceManager resourceManager;
    private final AtomicBoolean processedInitial = new AtomicBoolean();
    private int batchSize;
    private volatile CommandCursorResult<T> commandCursorResult;

    AsyncCommandBatchCursor(TimeoutMode timeoutMode, BsonDocument commandCursorDocument, int batchSize, long maxTimeMS, Decoder<T> decoder, @Nullable BsonValue comment, AsyncConnectionSource connectionSource, AsyncConnection connection) {
        ConnectionDescription connectionDescription = connection.getDescription();
        this.commandCursorResult = this.toCommandCursorResult(connectionDescription.getServerAddress(), "firstBatch", commandCursorDocument);
        this.namespace = this.commandCursorResult.getNamespace();
        this.batchSize = batchSize;
        this.maxTimeMS = maxTimeMS;
        this.decoder = decoder;
        this.comment = comment;
        this.maxWireVersion = connectionDescription.getMaxWireVersion();
        this.firstBatchEmpty = this.commandCursorResult.getResults().isEmpty();
        connectionSource.getOperationContext().getTimeoutContext().setMaxTimeOverride(maxTimeMS);
        AsyncConnection connectionToPin = connectionSource.getServerDescription().getType() == ServerType.LOAD_BALANCER ? connection : null;
        this.resourceManager = new ResourceManager(timeoutMode, this.namespace, connectionSource, connectionToPin, this.commandCursorResult.getServerCursor());
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        this.resourceManager.execute(funcCallback -> {
            this.resourceManager.checkTimeoutModeAndResetTimeoutContextIfIteration();
            ServerCursor localServerCursor = this.resourceManager.getServerCursor();
            boolean serverCursorIsNull = localServerCursor == null;
            List batchResults = Collections.emptyList();
            if (!this.processedInitial.getAndSet(true) && !this.firstBatchEmpty) {
                batchResults = this.commandCursorResult.getResults();
            }
            if (serverCursorIsNull || !batchResults.isEmpty()) {
                funcCallback.onResult(batchResults, null);
            } else {
                this.getMore(localServerCursor, funcCallback);
            }
        }, callback);
    }

    @Override
    public boolean isClosed() {
        return !this.resourceManager.operable();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public void close() {
        this.resourceManager.close();
    }

    @Nullable
    ServerCursor getServerCursor() {
        if (!this.resourceManager.operable()) {
            return null;
        }
        return this.resourceManager.getServerCursor();
    }

    @Override
    public BsonDocument getPostBatchResumeToken() {
        return this.commandCursorResult.getPostBatchResumeToken();
    }

    @Override
    public BsonTimestamp getOperationTime() {
        return this.commandCursorResult.getOperationTime();
    }

    @Override
    public boolean isFirstBatchEmpty() {
        return this.firstBatchEmpty;
    }

    @Override
    public int getMaxWireVersion() {
        return this.maxWireVersion;
    }

    private void getMore(ServerCursor cursor, SingleResultCallback<List<T>> callback) {
        this.resourceManager.executeWithConnection((connection, wrappedCallback) -> this.getMoreLoop(Assertions.assertNotNull(connection), cursor, wrappedCallback), callback);
    }

    private void getMoreLoop(AsyncConnection connection, ServerCursor serverCursor, SingleResultCallback<List<T>> callback) {
        connection.commandAsync(this.namespace.getDatabaseName(), CommandBatchCursorHelper.getMoreCommandDocument(serverCursor.getId(), connection.getDescription(), this.namespace, this.batchSize, this.comment), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), CommandResultDocumentCodec.create(this.decoder, "nextBatch"), Assertions.assertNotNull((AsyncConnectionSource)this.resourceManager.getConnectionSource()).getOperationContext(), (commandResult, t) -> {
            if (t != null) {
                Throwable translatedException = t instanceof MongoCommandException ? CommandBatchCursorHelper.translateCommandException((MongoCommandException)t, serverCursor) : t;
                callback.onResult(null, translatedException);
                return;
            }
            this.commandCursorResult = this.toCommandCursorResult(connection.getDescription().getServerAddress(), "nextBatch", Assertions.assertNotNull(commandResult));
            ServerCursor nextServerCursor = this.commandCursorResult.getServerCursor();
            this.resourceManager.setServerCursor(nextServerCursor);
            List<T> nextBatch = this.commandCursorResult.getResults();
            if (nextServerCursor == null || !nextBatch.isEmpty()) {
                callback.onResult(nextBatch, null);
                return;
            }
            if (!this.resourceManager.operable()) {
                callback.onResult(Collections.emptyList(), null);
                return;
            }
            this.getMoreLoop(connection, nextServerCursor, callback);
        });
    }

    private CommandCursorResult<T> toCommandCursorResult(ServerAddress serverAddress, String fieldNameContainingBatch, BsonDocument commandCursorDocument) {
        CommandCursorResult commandCursorResult = new CommandCursorResult(serverAddress, fieldNameContainingBatch, commandCursorDocument);
        CommandBatchCursorHelper.logCommandCursorResult(commandCursorResult);
        return commandCursorResult;
    }

    void setCloseWithoutTimeoutReset(boolean closeWithoutTimeoutReset) {
        this.resourceManager.setCloseWithoutTimeoutReset(closeWithoutTimeoutReset);
    }

    @ThreadSafe
    private static final class ResourceManager
    extends CursorResourceManager<AsyncConnectionSource, AsyncConnection> {
        ResourceManager(TimeoutMode timeoutMode, MongoNamespace namespace, AsyncConnectionSource connectionSource, @Nullable AsyncConnection connectionToPin, @Nullable ServerCursor serverCursor) {
            super(connectionSource.getOperationContext().getTimeoutContext(), timeoutMode, namespace, connectionSource, connectionToPin, serverCursor);
        }

        <R> void execute(AsyncCallbackSupplier<R> operation, SingleResultCallback<R> callback) {
            boolean canStartOperation = Assertions.doesNotThrow(this::tryStartOperation);
            if (!canStartOperation) {
                callback.onResult(null, new IllegalStateException("Cursor has been closed"));
            } else {
                operation.whenComplete(() -> {
                    this.endOperation();
                    if (this.getServerCursor() == null) {
                        this.close();
                    }
                }).get(callback);
            }
        }

        @Override
        void markAsPinned(AsyncConnection connectionToPin, Connection.PinningMode pinningMode) {
            connectionToPin.markAsPinned(pinningMode);
        }

        @Override
        void doClose() {
            if (this.isSkipReleasingServerResourcesOnClose()) {
                this.unsetServerCursor();
            }
            this.resetTimeout();
            if (this.getServerCursor() != null) {
                this.getConnection((connection, t) -> {
                    if (connection != null) {
                        this.releaseServerAndClientResources((AsyncConnection)connection);
                    } else {
                        this.unsetServerCursor();
                        this.releaseClientResources();
                    }
                });
            } else {
                this.releaseClientResources();
            }
        }

        <R> void executeWithConnection(AsyncOperationHelper.AsyncCallableConnectionWithCallback<R> callable, SingleResultCallback<R> callback) {
            this.getConnection((connection, t) -> {
                if (t != null) {
                    callback.onResult(null, t);
                    return;
                }
                callable.call(Assertions.assertNotNull(connection), (result, t1) -> {
                    if (t1 != null) {
                        this.handleException((AsyncConnection)connection, t1);
                    }
                    connection.release();
                    callback.onResult(result, t1);
                });
            });
        }

        private void handleException(AsyncConnection connection, Throwable exception) {
            if (exception instanceof MongoOperationTimeoutException && exception.getCause() instanceof MongoSocketException) {
                this.onCorruptedConnection(connection, (MongoSocketException)exception.getCause());
            } else if (exception instanceof MongoSocketException) {
                this.onCorruptedConnection(connection, (MongoSocketException)exception);
            }
        }

        private void getConnection(SingleResultCallback<AsyncConnection> callback) {
            Assertions.assertTrue(this.getState() != CursorResourceManager.State.IDLE);
            AsyncConnection pinnedConnection = (AsyncConnection)this.getPinnedConnection();
            if (pinnedConnection != null) {
                callback.onResult(Assertions.assertNotNull(pinnedConnection).retain(), null);
            } else {
                Assertions.assertNotNull((AsyncConnectionSource)this.getConnectionSource()).getConnection(callback);
            }
        }

        private void releaseServerAndClientResources(AsyncConnection connection) {
            AsyncCallbackSupplier callbackSupplier = funcCallback -> {
                ServerCursor localServerCursor = this.getServerCursor();
                if (localServerCursor != null) {
                    this.killServerCursor(this.getNamespace(), localServerCursor, connection, funcCallback);
                }
            };
            callbackSupplier.whenComplete(() -> {
                this.unsetServerCursor();
                this.releaseClientResources();
            }).whenComplete(connection::release).get((r, t) -> {});
        }

        private void killServerCursor(MongoNamespace namespace, ServerCursor localServerCursor, AsyncConnection localConnection, SingleResultCallback<Void> callback) {
            OperationContext operationContext = Assertions.assertNotNull((AsyncConnectionSource)this.getConnectionSource()).getOperationContext();
            TimeoutContext timeoutContext = operationContext.getTimeoutContext();
            timeoutContext.resetToDefaultMaxTime();
            localConnection.commandAsync(namespace.getDatabaseName(), CommandBatchCursorHelper.getKillCursorsCommand(namespace, localServerCursor), NoOpFieldNameValidator.INSTANCE, ReadPreference.primary(), new BsonDocumentCodec(), operationContext, (r, t) -> callback.onResult(null, null));
        }
    }
}

