/*
 * Decompiled with CFR 0.152.
 */
package com.dre.brewery.depend.mongodb.internal.operation;

import com.dre.brewery.depend.bson.BsonArray;
import com.dre.brewery.depend.bson.BsonBoolean;
import com.dre.brewery.depend.bson.BsonDocument;
import com.dre.brewery.depend.bson.BsonInt32;
import com.dre.brewery.depend.bson.BsonString;
import com.dre.brewery.depend.bson.BsonValue;
import com.dre.brewery.depend.bson.codecs.Decoder;
import com.dre.brewery.depend.mongodb.CursorType;
import com.dre.brewery.depend.mongodb.MongoNamespace;
import com.dre.brewery.depend.mongodb.assertions.Assertions;
import com.dre.brewery.depend.mongodb.client.cursor.TimeoutMode;
import com.dre.brewery.depend.mongodb.client.model.Collation;
import com.dre.brewery.depend.mongodb.internal.TimeoutContext;
import com.dre.brewery.depend.mongodb.internal.async.AsyncBatchCursor;
import com.dre.brewery.depend.mongodb.internal.async.ErrorHandlingResultCallback;
import com.dre.brewery.depend.mongodb.internal.async.SingleResultCallback;
import com.dre.brewery.depend.mongodb.internal.binding.AsyncReadBinding;
import com.dre.brewery.depend.mongodb.internal.binding.ReadBinding;
import com.dre.brewery.depend.mongodb.internal.client.model.AggregationLevel;
import com.dre.brewery.depend.mongodb.internal.connection.OperationContext;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncCommandBatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.AsyncReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.BatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.CommandBatchCursor;
import com.dre.brewery.depend.mongodb.internal.operation.CommandOperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.CommandResultDocumentCodec;
import com.dre.brewery.depend.mongodb.internal.operation.OperationHelper;
import com.dre.brewery.depend.mongodb.internal.operation.OperationReadConcernHelper;
import com.dre.brewery.depend.mongodb.internal.operation.ReadOperation;
import com.dre.brewery.depend.mongodb.internal.operation.SyncOperationHelper;
import com.dre.brewery.depend.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.List;

class AggregateOperationImpl<T>
implements AsyncReadOperation<AsyncBatchCursor<T>>,
ReadOperation<BatchCursor<T>> {
    private static final String RESULT = "result";
    private static final String CURSOR = "cursor";
    private static final String FIRST_BATCH = "firstBatch";
    private static final List<String> FIELD_NAMES_WITH_RESULT = Arrays.asList("result", "firstBatch");
    private final MongoNamespace namespace;
    private final List<BsonDocument> pipeline;
    private final Decoder<T> decoder;
    private final AggregateTarget aggregateTarget;
    private final PipelineCreator pipelineCreator;
    private boolean retryReads;
    private Boolean allowDiskUse;
    private Integer batchSize;
    private Collation collation;
    private BsonValue comment;
    private BsonValue hint;
    private BsonDocument variables;
    private TimeoutMode timeoutMode;
    private CursorType cursorType;

    AggregateOperationImpl(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregationLevel aggregationLevel) {
        this(namespace, pipeline, decoder, AggregateOperationImpl.defaultAggregateTarget(Assertions.notNull("aggregationLevel", aggregationLevel), Assertions.notNull("namespace", namespace).getCollectionName()), AggregateOperationImpl.defaultPipelineCreator(pipeline));
    }

    AggregateOperationImpl(MongoNamespace namespace, List<BsonDocument> pipeline, Decoder<T> decoder, AggregateTarget aggregateTarget, PipelineCreator pipelineCreator) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.aggregateTarget = Assertions.notNull("aggregateTarget", aggregateTarget);
        this.pipelineCreator = Assertions.notNull("pipelineCreator", pipelineCreator);
    }

    MongoNamespace getNamespace() {
        return this.namespace;
    }

    List<BsonDocument> getPipeline() {
        return this.pipeline;
    }

    Decoder<T> getDecoder() {
        return this.decoder;
    }

    Boolean getAllowDiskUse() {
        return this.allowDiskUse;
    }

    AggregateOperationImpl<T> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    Integer getBatchSize() {
        return this.batchSize;
    }

    AggregateOperationImpl<T> batchSize(@Nullable Integer batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    Collation getCollation() {
        return this.collation;
    }

    AggregateOperationImpl<T> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Nullable
    BsonValue getComment() {
        return this.comment;
    }

    AggregateOperationImpl<T> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    AggregateOperationImpl<T> let(@Nullable BsonDocument variables) {
        this.variables = variables;
        return this;
    }

    AggregateOperationImpl<T> retryReads(boolean retryReads) {
        this.retryReads = retryReads;
        return this;
    }

    AggregateOperationImpl<T> cursorType(CursorType cursorType) {
        this.cursorType = cursorType;
        return this;
    }

    boolean getRetryReads() {
        return this.retryReads;
    }

    @Nullable
    BsonValue getHint() {
        return this.hint;
    }

    public AggregateOperationImpl<T> timeoutMode(@Nullable TimeoutMode timeoutMode) {
        if (timeoutMode != null) {
            this.timeoutMode = timeoutMode;
        }
        return this;
    }

    AggregateOperationImpl<T> hint(@Nullable BsonValue hint) {
        Assertions.isTrueArgument("BsonString or BsonDocument", hint == null || hint.isDocument() || hint.isString());
        this.hint = hint;
        return this;
    }

    @Override
    public BatchCursor<T> execute(ReadBinding binding) {
        return SyncOperationHelper.executeRetryableRead(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.transformer(), this.retryReads);
    }

    @Override
    public void executeAsync(AsyncReadBinding binding, SingleResultCallback<AsyncBatchCursor<T>> callback) {
        SingleResultCallback<AsyncBatchCursor<T>> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
        AsyncOperationHelper.executeRetryableReadAsync(binding, this.namespace.getDatabaseName(), this.getCommandCreator(), CommandResultDocumentCodec.create(this.decoder, FIELD_NAMES_WITH_RESULT), this.asyncTransformer(), this.retryReads, errHandlingCallback);
    }

    private CommandOperationHelper.CommandCreator getCommandCreator() {
        return (operationContext, serverDescription, connectionDescription) -> this.getCommand(operationContext, connectionDescription.getMaxWireVersion());
    }

    BsonDocument getCommand(OperationContext operationContext, int maxWireVersion) {
        BsonDocument commandDocument = new BsonDocument("aggregate", this.aggregateTarget.create());
        OperationReadConcernHelper.appendReadConcernToCommand(operationContext.getSessionContext(), maxWireVersion, commandDocument);
        commandDocument.put("pipeline", this.pipelineCreator.create());
        OperationHelper.setNonTailableCursorMaxTimeSupplier(this.timeoutMode, operationContext);
        BsonDocument cursor = new BsonDocument();
        if (this.batchSize != null) {
            cursor.put("batchSize", new BsonInt32(this.batchSize));
        }
        commandDocument.put(CURSOR, cursor);
        if (this.allowDiskUse != null) {
            commandDocument.put("allowDiskUse", BsonBoolean.valueOf(this.allowDiskUse));
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        if (this.comment != null) {
            commandDocument.put("comment", this.comment);
        }
        if (this.hint != null) {
            commandDocument.put("hint", this.hint);
        }
        if (this.variables != null) {
            commandDocument.put("let", this.variables);
        }
        return commandDocument;
    }

    private SyncOperationHelper.CommandReadTransformer<BsonDocument, CommandBatchCursor<T>> transformer() {
        return (result, source, connection) -> new CommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)result, this.batchSize != null ? this.batchSize : 0, this.getMaxTimeForCursor(source.getOperationContext().getTimeoutContext()), this.decoder, this.comment, source, connection);
    }

    private AsyncOperationHelper.CommandReadTransformerAsync<BsonDocument, AsyncBatchCursor<T>> asyncTransformer() {
        return (result, source, connection) -> new AsyncCommandBatchCursor<T>(this.getTimeoutMode(), (BsonDocument)result, this.batchSize != null ? this.batchSize : 0, this.getMaxTimeForCursor(source.getOperationContext().getTimeoutContext()), this.decoder, this.comment, source, connection);
    }

    private TimeoutMode getTimeoutMode() {
        TimeoutMode localTimeoutMode = this.timeoutMode;
        if (localTimeoutMode == null) {
            localTimeoutMode = TimeoutMode.CURSOR_LIFETIME;
        }
        return localTimeoutMode;
    }

    private long getMaxTimeForCursor(TimeoutContext timeoutContext) {
        long maxAwaitTimeMS = timeoutContext.getMaxAwaitTimeMS();
        if (timeoutContext.hasTimeoutMS()) {
            return CursorType.TailableAwait == this.cursorType ? maxAwaitTimeMS : 0L;
        }
        return maxAwaitTimeMS;
    }

    private static AggregateTarget defaultAggregateTarget(AggregationLevel aggregationLevel, String collectionName) {
        return () -> {
            if (aggregationLevel == AggregationLevel.DATABASE) {
                return new BsonInt32(1);
            }
            return new BsonString(collectionName);
        };
    }

    private static PipelineCreator defaultPipelineCreator(List<BsonDocument> pipeline) {
        return () -> new BsonArray(pipeline);
    }

    static interface AggregateTarget {
        public BsonValue create();
    }

    static interface PipelineCreator {
        public BsonArray create();
    }
}

